/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.transaction.ExternalTransactionAwareTransactionFactory;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transaction.TransactionFactory;
import org.mule.tck.testmodels.mule.TestTransaction;
import org.mule.tck.testmodels.mule.TestTransactionFactory;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.MuleTransactionConfig;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.TransactionTemplate;
import org.mule.transaction.TransactionTemplateTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class TransactionTemplateTestCase {
    private static final Object RETURN_VALUE = new Object();
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class);
    @Spy
    private TestTransaction mockTransaction = new TestTransaction(this.mockMuleContext);
    @Spy
    private TestTransaction mockNewTransaction = new TestTransaction(this.mockMuleContext);
    @Mock
    private ExternalTransactionAwareTransactionFactory mockExternalTransactionFactory;

    @Before
    public void unbindTransaction() throws Exception {
        Transaction currentTransaction = TransactionCoordination.getInstance().getTransaction();
        if (currentTransaction != null) {
            TransactionCoordination.getInstance().unbindTransaction(currentTransaction);
        }
    }

    @Test
    public void testNoConfig() throws Exception {
        TransactionTemplate transactionTemplate = new TransactionTemplate(null, this.mockMuleContext);
        Object result = transactionTemplate.execute(TransactionTemplateTestUtils.getEmptyTransactionCallback(RETURN_VALUE));
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)RETURN_VALUE));
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionIndifferentConfig() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(6);
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        Object result = transactionTemplate.execute(TransactionTemplateTestUtils.getEmptyTransactionCallback(RETURN_VALUE));
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)RETURN_VALUE));
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionNeverAndNoTx() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(5);
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        Object result = transactionTemplate.execute(TransactionTemplateTestUtils.getEmptyTransactionCallback(RETURN_VALUE));
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)RETURN_VALUE));
    }

    @Test(expected=IllegalTransactionStateException.class)
    public void testActionNeverAndTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(5);
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        transactionTemplate.execute(TransactionTemplateTestUtils.getEmptyTransactionCallback(RETURN_VALUE));
    }

    @Test
    public void testActionNoneAndNoTx() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(0);
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        Object result = transactionTemplate.execute(TransactionTemplateTestUtils.getEmptyTransactionCallback(RETURN_VALUE));
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)RETURN_VALUE));
    }

    @Test
    public void testActionNoneAndTxForCommit() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(0);
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        Object result = transactionTemplate.execute(TransactionTemplateTestUtils.getEmptyTransactionCallback(RETURN_VALUE));
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
    }

    @Test
    public void testActionNoneAndTxForRollback() throws Exception {
        Mockito.when((Object)this.mockTransaction.isRollbackOnly()).thenReturn((Object)true);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(0);
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        Object result = transactionTemplate.execute(TransactionTemplateTestUtils.getEmptyTransactionCallback(RETURN_VALUE));
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
    }

    @Test
    public void testActionNoneAndXaTx() throws Exception {
        this.mockTransaction.setXA(true);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(0);
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        Object result = transactionTemplate.execute(TransactionTemplateTestUtils.getEmptyTransactionCallback(RETURN_VALUE));
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).suspend();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).resume();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
    }

    @Test
    public void testActionNoneAndXaTxAndFailureInCallback() throws Exception {
        this.mockTransaction.setXA(true);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(0);
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        try {
            transactionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback());
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).suspend();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
    }

    @Test
    public void testActionNoneAndWithExternalTransactionWithNoTx() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(0);
        config.setInteractWithExternal(true);
        this.mockExternalTransactionFactory = (ExternalTransactionAwareTransactionFactory)Mockito.mock(ExternalTransactionAwareTransactionFactory.class);
        config.setFactory((TransactionFactory)this.mockExternalTransactionFactory);
        Mockito.when((Object)this.mockExternalTransactionFactory.joinExternalTransaction(this.mockMuleContext)).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                TransactionCoordination.getInstance().bindTransaction((Transaction)TransactionTemplateTestCase.this.mockTransaction);
                return TransactionTemplateTestCase.this.mockTransaction;
            }
        });
        this.mockTransaction.setXA(true);
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        Object result = transactionTemplate.execute(TransactionTemplateTestUtils.getEmptyTransactionCallback(RETURN_VALUE));
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).suspend();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).resume();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionNoneAndWithExternalTransactionWithTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(0);
        config.setInteractWithExternal(true);
        this.mockExternalTransactionFactory = (ExternalTransactionAwareTransactionFactory)Mockito.mock(ExternalTransactionAwareTransactionFactory.class);
        config.setFactory((TransactionFactory)this.mockExternalTransactionFactory);
        Transaction externalTransaction = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)this.mockExternalTransactionFactory.joinExternalTransaction(this.mockMuleContext)).thenReturn((Object)externalTransaction);
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        Object result = transactionTemplate.execute(TransactionTemplateTestUtils.getEmptyTransactionCallback(RETURN_VALUE));
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionAlwaysBeginAndNoTx() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(1);
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockTransaction));
        Object result = transactionTemplate.execute(TransactionTemplateTestUtils.getEmptyTransactionCallback(RETURN_VALUE));
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionAlwaysBeginAndCommitTxAndCommitNewTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(1);
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockNewTransaction));
        Object result = transactionTemplate.execute(TransactionTemplateTestUtils.getEmptyTransactionCallback(RETURN_VALUE));
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockNewTransaction)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockNewTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionAlwaysBeginAndRollbackTxAndCommitNewTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        Mockito.when((Object)this.mockTransaction.isRollbackOnly()).thenReturn((Object)true);
        MuleTransactionConfig config = new MuleTransactionConfig(1);
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockNewTransaction));
        Object result = transactionTemplate.execute(TransactionTemplateTestUtils.getEmptyTransactionCallback(RETURN_VALUE));
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockNewTransaction)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockNewTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionAlwaysBeginAndRollbackTxAndRollbackNewTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        Mockito.when((Object)this.mockTransaction.isRollbackOnly()).thenReturn((Object)true);
        MuleTransactionConfig config = new MuleTransactionConfig(1);
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockNewTransaction));
        Object result = transactionTemplate.execute(TransactionTemplateTestUtils.getRollbackTransactionCallback(RETURN_VALUE));
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockNewTransaction)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockNewTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionAlwaysBeginAndSuspendXaTxAndCommitNewTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.mockTransaction.setXA(true);
        MuleTransactionConfig config = new MuleTransactionConfig(1);
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockNewTransaction));
        Object result = transactionTemplate.execute(TransactionTemplateTestUtils.getEmptyTransactionCallback(RETURN_VALUE));
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockNewTransaction)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockNewTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).suspend();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).resume();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)((Object)((TestTransaction)TransactionCoordination.getInstance().getTransaction())), (Matcher)Is.is((Object)((Object)this.mockTransaction)));
    }

    @Test
    public void testActionAlwaysBeginAndSuspendXaTxAndRollbackNewTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.mockTransaction.setXA(true);
        Mockito.when((Object)this.mockTransaction.isRollbackOnly()).thenReturn((Object)true);
        MuleTransactionConfig config = new MuleTransactionConfig(1);
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockNewTransaction));
        Object result = transactionTemplate.execute(TransactionTemplateTestUtils.getRollbackTransactionCallback(RETURN_VALUE));
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockNewTransaction)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockNewTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).suspend();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).resume();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)((Object)((TestTransaction)TransactionCoordination.getInstance().getTransaction())), (Matcher)Is.is((Object)((Object)this.mockTransaction)));
    }

    @Test
    public void testActionAlwaysBeginAndSuspendXaTxAndFailureCallback() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.mockTransaction.setXA(true);
        MuleTransactionConfig config = new MuleTransactionConfig(1);
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockNewTransaction));
        try {
            transactionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback());
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).suspend();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
    }

    @Test(expected=IllegalTransactionStateException.class)
    public void testActionAlwaysJoinAndNoTx() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(3);
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        transactionTemplate.execute(TransactionTemplateTestUtils.getRollbackTransactionCallback(RETURN_VALUE));
    }

    @Test
    public void testActionAlwaysJoinAndTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(3);
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        Object result = transactionTemplate.execute(TransactionTemplateTestUtils.getRollbackTransactionCallback(RETURN_VALUE));
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)((Object)((TestTransaction)TransactionCoordination.getInstance().getTransaction())), (Matcher)Is.is((Object)((Object)this.mockTransaction)));
    }

    @Test
    public void testActionAlwaysJoinAndExternalTxAndFailureCallback() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(3);
        config.setInteractWithExternal(true);
        this.mockExternalTransactionFactory = (ExternalTransactionAwareTransactionFactory)Mockito.mock(ExternalTransactionAwareTransactionFactory.class);
        config.setFactory((TransactionFactory)this.mockExternalTransactionFactory);
        Mockito.when((Object)this.mockExternalTransactionFactory.joinExternalTransaction(this.mockMuleContext)).thenAnswer((Answer)new Answer<Transaction>(){

            public Transaction answer(InvocationOnMock invocationOnMock) throws Throwable {
                TransactionCoordination.getInstance().bindTransaction((Transaction)TransactionTemplateTestCase.this.mockTransaction);
                return TransactionTemplateTestCase.this.mockTransaction;
            }
        });
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        try {
            transactionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback());
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionBeginOrJoinAndNoTx() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(2);
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockTransaction));
        Object result = transactionTemplate.execute(TransactionTemplateTestUtils.getEmptyTransactionCallback(RETURN_VALUE));
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionBeginOrJoinAndTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(2);
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockTransaction));
        Object result = transactionTemplate.execute(TransactionTemplateTestUtils.getEmptyTransactionCallback(RETURN_VALUE));
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)((Object)((TestTransaction)TransactionCoordination.getInstance().getTransaction())), (Matcher)Is.is((Object)((Object)this.mockTransaction)));
    }

    @Test
    public void testActionJoinIfPossibleAndNoTx() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(4);
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        Object result = transactionTemplate.execute(TransactionTemplateTestUtils.getEmptyTransactionCallback(RETURN_VALUE));
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)RETURN_VALUE));
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionJoinIfPossibleAndTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(4);
        TransactionTemplate transactionTemplate = new TransactionTemplate((TransactionConfig)config, this.mockMuleContext);
        Object result = transactionTemplate.execute(TransactionTemplateTestUtils.getEmptyTransactionCallback(RETURN_VALUE));
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)((Object)((TestTransaction)TransactionCoordination.getInstance().getTransaction())), (Matcher)Is.is((Object)((Object)this.mockTransaction)));
    }
}

