/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MessagingException;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionCallback;
import org.mule.transaction.TransactionCoordination;

public class TransactionTemplateTestUtils {
    public static TransactionCallback getEmptyTransactionCallback(final Object returnObject) {
        return new TransactionCallback(){

            public Object doInTransaction() throws Exception {
                return returnObject;
            }
        };
    }

    public static TransactionCallback getRollbackTransactionCallback(final Object returnObject) {
        return new TransactionCallback(){

            public Object doInTransaction() throws Exception {
                TransactionCoordination.getInstance().getTransaction().setRollbackOnly();
                return returnObject;
            }
        };
    }

    public static TransactionCallback getFailureTransactionCallback() throws Exception {
        return new TransactionCallback(){

            public Object doInTransaction() throws Exception {
                throw (MessagingException)Mockito.mock(MessagingException.class, (Answer)Answers.RETURNS_MOCKS.get());
            }
        };
    }

    public static TransactionCallback getFailureTransactionCallback(final MessagingException mockMessagingException) throws Exception {
        return new TransactionCallback(){

            public Object doInTransaction() throws Exception {
                throw mockMessagingException;
            }
        };
    }

    public static TransactionCallback getFailureTransactionCallbackStartsTransaction(final MessagingException mockMessagingException, final Transaction mockTransaction) {
        return new TransactionCallback(){

            public Object doInTransaction() throws Exception {
                TransactionCoordination.getInstance().bindTransaction(mockTransaction);
                throw mockMessagingException;
            }
        };
    }
}

