/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.service.Service;
import org.mule.api.source.CompositeMessageSource;
import org.mule.api.source.MessageSource;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageDispatcher;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.MessageRequester;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.AbstractMessageRequester;

public class ConnectorLifecycleTestCase
extends AbstractMuleContextTestCase {
    private TestConnector connector;

    @Override
    public void doSetUp() throws Exception {
        this.connector = new TestConnector(muleContext);
        this.connector.initialise();
    }

    @Override
    public void doTearDown() throws Exception {
        if (!this.connector.isDisposed()) {
            this.connector.dispose();
        }
        this.connector = null;
    }

    @Test
    public void testDoubleInitialiseConnector() throws Exception {
        Assert.assertEquals((long)1L, (long)this.connector.getInitialiseCount());
        Assert.assertEquals((long)0L, (long)this.connector.getConnectCount());
        Assert.assertEquals((long)0L, (long)this.connector.getStartCount());
        Assert.assertEquals((long)0L, (long)this.connector.getStopCount());
        Assert.assertEquals((long)0L, (long)this.connector.getDisconnectCount());
        Assert.assertEquals((long)0L, (long)this.connector.getDisposeCount());
        try {
            this.connector.initialise();
            junit.framework.Assert.fail((String)"Expected IllegalStateException not thrown.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testDoubleStartConnector() throws Exception {
        this.connector.start();
        Assert.assertEquals((long)1L, (long)this.connector.getInitialiseCount());
        Assert.assertEquals((long)1L, (long)this.connector.getConnectCount());
        Assert.assertEquals((long)1L, (long)this.connector.getStartCount());
        Assert.assertEquals((long)0L, (long)this.connector.getStopCount());
        Assert.assertEquals((long)0L, (long)this.connector.getDisconnectCount());
        Assert.assertEquals((long)0L, (long)this.connector.getDisposeCount());
        try {
            this.connector.start();
            Assert.fail((String)"cannot start the connector twice");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)this.connector.getInitialiseCount());
        Assert.assertEquals((long)1L, (long)this.connector.getConnectCount());
        Assert.assertEquals((long)1L, (long)this.connector.getStartCount());
        Assert.assertEquals((long)0L, (long)this.connector.getStopCount());
        Assert.assertEquals((long)0L, (long)this.connector.getDisconnectCount());
        Assert.assertEquals((long)0L, (long)this.connector.getDisposeCount());
    }

    @Test
    public void testDoubleStopConnector() throws Exception {
        this.connector.start();
        Assert.assertEquals((long)1L, (long)this.connector.getInitialiseCount());
        Assert.assertEquals((long)1L, (long)this.connector.getConnectCount());
        Assert.assertEquals((long)1L, (long)this.connector.getStartCount());
        Assert.assertEquals((long)0L, (long)this.connector.getStopCount());
        Assert.assertEquals((long)0L, (long)this.connector.getDisconnectCount());
        Assert.assertEquals((long)0L, (long)this.connector.getDisposeCount());
        Assert.assertTrue((boolean)this.connector.isStarted());
        this.connector.stop();
        Assert.assertEquals((long)1L, (long)this.connector.getInitialiseCount());
        Assert.assertEquals((long)1L, (long)this.connector.getConnectCount());
        Assert.assertEquals((long)1L, (long)this.connector.getStartCount());
        Assert.assertEquals((long)1L, (long)this.connector.getStopCount());
        Assert.assertEquals((long)0L, (long)this.connector.getDisconnectCount());
        Assert.assertEquals((long)0L, (long)this.connector.getDisposeCount());
        try {
            this.connector.stop();
            Assert.fail((String)"cannot stop the connector twice");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.connector.disconnect();
        Assert.assertEquals((long)1L, (long)this.connector.getInitialiseCount());
        Assert.assertEquals((long)1L, (long)this.connector.getConnectCount());
        Assert.assertEquals((long)1L, (long)this.connector.getStartCount());
        Assert.assertEquals((long)1L, (long)this.connector.getStopCount());
        Assert.assertEquals((long)1L, (long)this.connector.getDisconnectCount());
        Assert.assertEquals((long)0L, (long)this.connector.getDisposeCount());
    }

    @Test
    public void testDoubleDisposeConnectorStartStop() throws Exception {
        this.connector.start();
        Assert.assertTrue((boolean)this.connector.isStarted());
        this.connector.stop();
        Assert.assertFalse((boolean)this.connector.isStarted());
        this.connector.dispose();
        Assert.assertEquals((long)1L, (long)this.connector.getInitialiseCount());
        Assert.assertEquals((long)1L, (long)this.connector.getConnectCount());
        Assert.assertEquals((long)1L, (long)this.connector.getStartCount());
        Assert.assertEquals((long)1L, (long)this.connector.getStopCount());
        Assert.assertEquals((long)1L, (long)this.connector.getDisconnectCount());
        Assert.assertEquals((long)1L, (long)this.connector.getDisposeCount());
        try {
            this.connector.dispose();
            Assert.fail((String)"cannot dispose the connector twice");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)this.connector.getInitialiseCount());
        Assert.assertEquals((long)1L, (long)this.connector.getConnectCount());
        Assert.assertEquals((long)1L, (long)this.connector.getStartCount());
        Assert.assertEquals((long)1L, (long)this.connector.getStopCount());
        Assert.assertEquals((long)1L, (long)this.connector.getDisconnectCount());
        Assert.assertEquals((long)1L, (long)this.connector.getDisposeCount());
    }

    @Test
    public void testDoubleDisposeConnectorStartOnly() throws Exception {
        this.connector.start();
        Assert.assertTrue((boolean)this.connector.isStarted());
        this.connector.dispose();
        Assert.assertEquals((long)1L, (long)this.connector.getInitialiseCount());
        Assert.assertEquals((long)1L, (long)this.connector.getConnectCount());
        Assert.assertEquals((long)1L, (long)this.connector.getStartCount());
        Assert.assertEquals((long)1L, (long)this.connector.getStopCount());
        Assert.assertEquals((long)1L, (long)this.connector.getDisconnectCount());
        Assert.assertEquals((long)1L, (long)this.connector.getDisposeCount());
        try {
            this.connector.dispose();
            Assert.fail((String)"cannot dispose the connector twice");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)this.connector.getInitialiseCount());
        Assert.assertEquals((long)1L, (long)this.connector.getConnectCount());
        Assert.assertEquals((long)1L, (long)this.connector.getStartCount());
        Assert.assertEquals((long)1L, (long)this.connector.getStopCount());
        Assert.assertEquals((long)1L, (long)this.connector.getDisconnectCount());
        Assert.assertEquals((long)1L, (long)this.connector.getDisposeCount());
    }

    @Test
    public void testDoubleDisposeConnector() throws Exception {
        this.connector.dispose();
        Assert.assertEquals((long)1L, (long)this.connector.getInitialiseCount());
        Assert.assertEquals((long)0L, (long)this.connector.getConnectCount());
        Assert.assertEquals((long)0L, (long)this.connector.getStartCount());
        Assert.assertEquals((long)0L, (long)this.connector.getStopCount());
        Assert.assertEquals((long)0L, (long)this.connector.getDisconnectCount());
        Assert.assertEquals((long)1L, (long)this.connector.getDisposeCount());
        try {
            this.connector.dispose();
            Assert.fail((String)"cannot dispose the connector twice");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)this.connector.getInitialiseCount());
        Assert.assertEquals((long)0L, (long)this.connector.getConnectCount());
        Assert.assertEquals((long)0L, (long)this.connector.getStartCount());
        Assert.assertEquals((long)0L, (long)this.connector.getStopCount());
        Assert.assertEquals((long)0L, (long)this.connector.getDisconnectCount());
        Assert.assertEquals((long)1L, (long)this.connector.getDisposeCount());
    }

    @Test
    public void testReceiversLifecycle() throws Exception {
        Service service = ConnectorLifecycleTestCase.getTestService();
        service.start();
        this.connector.registerListener(ConnectorLifecycleTestCase.getTestInboundEndpoint("in", "test://in"), this.getSensingNullMessageProcessor(), (FlowConstruct)service);
        Assert.assertEquals((long)1L, (long)this.connector.receivers.size());
        Assert.assertFalse((boolean)((MessageReceiver)this.connector.receivers.get("in")).isConnected());
        Assert.assertFalse((boolean)((AbstractMessageReceiver)this.connector.receivers.get("in")).isStarted());
        this.connector.start();
        Assert.assertTrue((boolean)((MessageReceiver)this.connector.receivers.get("in")).isConnected());
        Assert.assertTrue((boolean)((AbstractMessageReceiver)this.connector.receivers.get("in")).isStarted());
        this.connector.registerListener(ConnectorLifecycleTestCase.getTestInboundEndpoint("in2", "test://in2"), this.getSensingNullMessageProcessor(), (FlowConstruct)service);
        Assert.assertEquals((long)2L, (long)this.connector.receivers.size());
        Assert.assertTrue((boolean)((MessageReceiver)this.connector.receivers.get("in")).isConnected());
        Assert.assertTrue((boolean)((AbstractMessageReceiver)this.connector.receivers.get("in")).isStarted());
        Assert.assertTrue((boolean)((MessageReceiver)this.connector.receivers.get("in2")).isConnected());
        Assert.assertTrue((boolean)((AbstractMessageReceiver)this.connector.receivers.get("in2")).isStarted());
        this.connector.stop();
        Assert.assertEquals((long)2L, (long)this.connector.receivers.size());
        Assert.assertTrue((boolean)((MessageReceiver)this.connector.receivers.get("in")).isConnected());
        Assert.assertFalse((boolean)((AbstractMessageReceiver)this.connector.receivers.get("in")).isStarted());
        Assert.assertTrue((boolean)((MessageReceiver)this.connector.receivers.get("in2")).isConnected());
        Assert.assertFalse((boolean)((AbstractMessageReceiver)this.connector.receivers.get("in2")).isStarted());
        this.connector.disconnect();
        Assert.assertEquals((long)2L, (long)this.connector.receivers.size());
        Assert.assertFalse((boolean)((MessageReceiver)this.connector.receivers.get("in")).isConnected());
        Assert.assertFalse((boolean)((MessageReceiver)this.connector.receivers.get("in2")).isConnected());
        this.connector.start();
        Assert.assertEquals((long)2L, (long)this.connector.receivers.size());
        Assert.assertTrue((boolean)((MessageReceiver)this.connector.receivers.get("in")).isConnected());
        Assert.assertTrue((boolean)((AbstractMessageReceiver)this.connector.receivers.get("in")).isStarted());
        Assert.assertTrue((boolean)((MessageReceiver)this.connector.receivers.get("in2")).isConnected());
        Assert.assertTrue((boolean)((AbstractMessageReceiver)this.connector.receivers.get("in2")).isStarted());
        this.connector.dispose();
        Assert.assertEquals((long)0L, (long)this.connector.receivers.size());
    }

    @Test
    public void testReceiversServiceLifecycle() throws Exception {
        Service service = ConnectorLifecycleTestCase.getTestService();
        InboundEndpoint endpoint = ConnectorLifecycleTestCase.getTestInboundEndpoint("in", "test://in");
        ((CompositeMessageSource)service.getMessageSource()).addSource((MessageSource)endpoint);
        this.connector = (TestConnector)endpoint.getConnector();
        Assert.assertEquals((long)0L, (long)this.connector.receivers.size());
        this.connector.start();
        Assert.assertEquals((long)0L, (long)this.connector.receivers.size());
        service.start();
        Assert.assertEquals((long)1L, (long)this.connector.receivers.size());
        Assert.assertTrue((boolean)((MessageReceiver)this.connector.receivers.get("in")).isConnected());
        Assert.assertTrue((boolean)((AbstractMessageReceiver)this.connector.receivers.get("in")).isStarted());
        this.connector.stop();
        Assert.assertEquals((long)1L, (long)this.connector.receivers.size());
        Assert.assertTrue((boolean)((MessageReceiver)this.connector.receivers.get("in")).isConnected());
        Assert.assertFalse((boolean)((AbstractMessageReceiver)this.connector.receivers.get("in")).isStarted());
        this.connector.disconnect();
        Assert.assertEquals((long)1L, (long)this.connector.receivers.size());
        Assert.assertFalse((boolean)((MessageReceiver)this.connector.receivers.get("in")).isConnected());
        this.connector.start();
        Assert.assertEquals((long)1L, (long)this.connector.receivers.size());
        Assert.assertTrue((boolean)((MessageReceiver)this.connector.receivers.get("in")).isConnected());
        Assert.assertTrue((boolean)((AbstractMessageReceiver)this.connector.receivers.get("in")).isStarted());
        service.stop();
        Assert.assertEquals((long)0L, (long)this.connector.receivers.size());
        this.connector.stop();
        Assert.assertEquals((long)0L, (long)this.connector.receivers.size());
    }

    @Test
    public void testDispatchersLifecycle() throws Exception {
        OutboundEndpoint out = ConnectorLifecycleTestCase.getTestOutboundEndpoint("out", "test://out?exchangePattern=request-response", null, null, null, (Connector)this.connector);
        try {
            out.process(ConnectorLifecycleTestCase.getTestEvent("data"));
            Assert.fail((String)"cannot send on a connector that is not started");
        }
        catch (LifecycleException e) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.connector.dispatchers.getNumIdle());
        this.assertDispatcherStartedConnected(out, false, false);
        this.connector.start();
        this.assertDispatcherStartedConnected(out, true, true);
        OutboundEndpoint out2 = ConnectorLifecycleTestCase.getTestOutboundEndpoint("out2", "test://out2?exchangePattern=request-response", null, null, null, (Connector)this.connector);
        out2.process(ConnectorLifecycleTestCase.getTestEvent("data"));
        Assert.assertEquals((long)2L, (long)this.connector.dispatchers.getNumIdle());
        this.assertDispatcherStartedConnected(out, true, true);
        this.assertDispatcherStartedConnected(out2, true, true);
        this.connector.stop();
        Assert.assertEquals((long)0L, (long)(this.connector.dispatchers.getNumActive() + this.connector.dispatchers.getNumIdle()));
        this.assertDispatcherStartedConnected(out, false, false);
        this.assertDispatcherStartedConnected(out2, false, false);
        this.connector.start();
        Assert.assertEquals((long)2L, (long)(this.connector.dispatchers.getNumActive() + this.connector.dispatchers.getNumIdle()));
        this.assertDispatcherStartedConnected(out, true, true);
        this.assertDispatcherStartedConnected(out2, true, true);
        out.process(ConnectorLifecycleTestCase.getTestEvent("data"));
        Assert.assertEquals((long)2L, (long)this.connector.dispatchers.getNumIdle());
        this.assertDispatcherStartedConnected(out, true, true);
        this.connector.dispose();
        Assert.assertEquals((long)0L, (long)(this.connector.dispatchers.getNumActive() + this.connector.dispatchers.getNumIdle()));
    }

    @Test
    public void testDispatcherFullLifecycle() throws Exception {
        OutboundEndpoint out = ConnectorLifecycleTestCase.getTestOutboundEndpoint("out", "test://out", null, null, null, (Connector)this.connector);
        MessageDispatcher dispatcher = this.connector.getDispatcherFactory().create(out);
        dispatcher.initialise();
        Assert.assertTrue((boolean)dispatcher.getLifecycleState().isInitialised());
        dispatcher.connect();
        Assert.assertTrue((boolean)dispatcher.isConnected());
        dispatcher.start();
        Assert.assertTrue((boolean)dispatcher.getLifecycleState().isStarted());
        dispatcher.stop();
        Assert.assertTrue((boolean)dispatcher.getLifecycleState().isStopped());
        dispatcher.disconnect();
        Assert.assertFalse((boolean)dispatcher.isConnected());
        dispatcher.dispose();
        Assert.assertTrue((boolean)dispatcher.getLifecycleState().isDisposed());
    }

    @Test
    public void testRequestersLifecycle() throws Exception {
        InboundEndpoint in = ConnectorLifecycleTestCase.getTestInboundEndpoint("in", "test://in", null, null, null, (Connector)this.connector);
        try {
            in.request(1000L);
            Assert.fail((String)"cannot sent on a connector that is not started");
        }
        catch (LifecycleException e) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.connector.requesters.getNumIdle());
        this.assertRequesterStartedConnected(in, false, false);
        this.connector.start();
        this.assertRequesterStartedConnected(in, true, true);
        Assert.assertEquals((long)1L, (long)this.connector.requesters.getNumIdle());
        InboundEndpoint in2 = ConnectorLifecycleTestCase.getTestInboundEndpoint("in2", "test://in2", null, null, null, (Connector)this.connector);
        in2.request(1000L);
        Assert.assertEquals((long)2L, (long)this.connector.requesters.getNumIdle());
        this.assertRequesterStartedConnected(in, true, true);
        this.assertRequesterStartedConnected(in2, true, true);
        this.connector.stop();
        Assert.assertEquals((long)0L, (long)(this.connector.requesters.getNumActive() + this.connector.requesters.getNumIdle()));
        this.assertRequesterStartedConnected(in, false, false);
        this.assertRequesterStartedConnected(in2, false, false);
        this.connector.start();
        Assert.assertEquals((long)2L, (long)(this.connector.requesters.getNumActive() + this.connector.requesters.getNumIdle()));
        this.assertRequesterStartedConnected(in, true, true);
        this.assertRequesterStartedConnected(in2, true, true);
        in.request(1000L);
        Assert.assertEquals((long)2L, (long)this.connector.requesters.getNumIdle());
        this.assertRequesterStartedConnected(in, true, true);
        this.connector.dispose();
        Assert.assertEquals((long)0L, (long)(this.connector.requesters.getNumActive() + this.connector.requesters.getNumIdle()));
    }

    @Test
    public void testRequesterFullLifecycle() throws Exception {
        InboundEndpoint in = ConnectorLifecycleTestCase.getTestInboundEndpoint("out", "test://out", null, null, null, (Connector)this.connector);
        MessageRequester requester = this.connector.getRequesterFactory().create(in);
        requester.initialise();
        Assert.assertTrue((boolean)requester.getLifecycleState().isInitialised());
        requester.connect();
        Assert.assertTrue((boolean)requester.isConnected());
        requester.start();
        Assert.assertTrue((boolean)requester.getLifecycleState().isStarted());
        requester.stop();
        Assert.assertTrue((boolean)requester.getLifecycleState().isStopped());
        requester.disconnect();
        Assert.assertFalse((boolean)requester.isConnected());
        requester.dispose();
        Assert.assertTrue((boolean)requester.getLifecycleState().isDisposed());
    }

    @Test
    public void testWorkManagerLifecycle() throws MuleException, WorkException {
        this.connector.start();
        Assert.assertNotNull((Object)this.connector.getReceiverWorkManager());
        Assert.assertNotNull((Object)this.connector.getDispatcherWorkManager());
        Assert.assertNotNull((Object)this.connector.getRequesterWorkManager());
        this.connector.getReceiverWorkManager().doWork(this.createSomeWork());
        this.connector.getDispatcherWorkManager().doWork(this.createSomeWork());
        this.connector.getRequesterWorkManager().doWork(this.createSomeWork());
        this.connector.stop();
        Assert.assertNull((Object)this.connector.getReceiverWorkManager());
        Assert.assertNull((Object)this.connector.getDispatcherWorkManager());
        Assert.assertNull((Object)this.connector.getRequesterWorkManager());
        this.connector.start();
        Assert.assertNotNull((Object)this.connector.getReceiverWorkManager());
        Assert.assertNotNull((Object)this.connector.getDispatcherWorkManager());
        Assert.assertNotNull((Object)this.connector.getRequesterWorkManager());
        this.connector.getReceiverWorkManager().doWork(this.createSomeWork());
        this.connector.getDispatcherWorkManager().doWork(this.createSomeWork());
        this.connector.getRequesterWorkManager().doWork(this.createSomeWork());
        this.connector.dispose();
        Assert.assertNull((Object)this.connector.getReceiverWorkManager());
        Assert.assertNull((Object)this.connector.getDispatcherWorkManager());
        Assert.assertNull((Object)this.connector.getRequesterWorkManager());
    }

    @Test
    public void testSchedulerLifecycle() throws MuleException, WorkException {
        Assert.assertNull((Object)this.connector.getScheduler());
        this.connector.start();
        Assert.assertFalse((boolean)this.connector.getScheduler().isShutdown());
        Assert.assertFalse((boolean)this.connector.getScheduler().isTerminated());
        this.connector.stop();
        Assert.assertNull((Object)this.connector.getScheduler());
        this.connector.start();
        Assert.assertFalse((boolean)this.connector.getScheduler().isShutdown());
        Assert.assertFalse((boolean)this.connector.getScheduler().isTerminated());
        this.connector.dispose();
        Assert.assertNull((Object)this.connector.getScheduler());
    }

    protected Work createSomeWork() {
        return new Work(){

            public void run() {
                System.out.println("I'm doing some work");
            }

            public void release() {
            }
        };
    }

    private void assertDispatcherStartedConnected(OutboundEndpoint out, boolean started, boolean connected) throws Exception {
        AbstractMessageDispatcher dispatcher = (AbstractMessageDispatcher)this.connector.dispatchers.borrowObject((Object)out);
        Assert.assertEquals((String)"Dispatcher started", (Object)started, (Object)dispatcher.isStarted());
        Assert.assertEquals((String)"Dispatcher connected", (Object)connected, (Object)dispatcher.isConnected());
        this.connector.dispatchers.returnObject((Object)out, (Object)dispatcher);
    }

    private void assertRequesterStartedConnected(InboundEndpoint in, boolean started, boolean connected) throws Exception {
        AbstractMessageRequester requester = (AbstractMessageRequester)this.connector.requesters.borrowObject((Object)in);
        Assert.assertEquals((String)"Requester started", (Object)started, (Object)requester.isStarted());
        Assert.assertEquals((String)"requester connected", (Object)connected, (Object)requester.isConnected());
        this.connector.requesters.returnObject((Object)in, (Object)requester);
    }
}

