/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.scan.annotations;

import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.scan.annotations.AnnotationInfo;
import org.mule.util.scan.annotations.AnnotationsScanner;
import org.mule.util.scan.annotations.ClosableClassReader;
import org.mule.util.scan.annotations.Marker;
import org.mule.util.scan.annotations.MultiMarker;
import org.mule.util.scan.annotations.SampleClassWithAnnotations;
import org.objectweb.asm.ClassVisitor;

public class AnnotationsScannerTestCase
extends AbstractMuleTestCase {
    protected AnnotationsScanner scanner;

    @Before
    public void setUp() throws IOException {
        ClosableClassReader r = new ClosableClassReader(SampleClassWithAnnotations.class.getName());
        this.scanner = new AnnotationsScanner();
        r.accept((ClassVisitor)this.scanner, 0);
    }

    @Test
    public void testParamAnnotations() throws Exception {
        List paramAnnotations = this.scanner.getParamAnnotations();
        System.out.println("Parameter annotations: " + paramAnnotations);
        Assert.assertNotNull((Object)paramAnnotations);
        Assert.assertEquals((long)2L, (long)paramAnnotations.size());
        AnnotationInfo ann = (AnnotationInfo)paramAnnotations.get(0);
        Assert.assertEquals((Object)Marker.class.getName(), (Object)ann.getClassName());
        List annValues = ann.getParams();
        Assert.assertNotNull((Object)annValues);
        Assert.assertEquals((long)1L, (long)annValues.size());
        Assert.assertEquals((Object)new AnnotationInfo.NameValue("value", (Object)"ParamLevel"), annValues.get(0));
        ann = (AnnotationInfo)paramAnnotations.get(1);
        Assert.assertEquals((Object)MultiMarker.class.getName(), (Object)ann.getClassName());
        annValues = ann.getParams();
        Assert.assertNotNull((Object)annValues);
        Assert.assertEquals((long)3L, (long)annValues.size());
        Assert.assertEquals((Object)new AnnotationInfo.NameValue("value", (Object)"ParamLevel"), annValues.get(0));
        Assert.assertEquals((Object)new AnnotationInfo.NameValue("param1", (Object)"12"), annValues.get(1));
        Assert.assertEquals((Object)new AnnotationInfo.NameValue("param2", (Object)"abc"), annValues.get(2));
    }

    @Test
    public void testFieldAnnotations() throws Exception {
        List fieldAnnotations = this.scanner.getFieldAnnotations();
        System.out.println("Field annotations: " + fieldAnnotations);
        Assert.assertNotNull((Object)fieldAnnotations);
        Assert.assertEquals((long)1L, (long)fieldAnnotations.size());
        AnnotationInfo ann = (AnnotationInfo)fieldAnnotations.get(0);
        Assert.assertEquals((Object)Marker.class.getName(), (Object)ann.getClassName());
        List annValues = ann.getParams();
        Assert.assertNotNull((Object)annValues);
        Assert.assertEquals((long)1L, (long)annValues.size());
        Assert.assertEquals((Object)new AnnotationInfo.NameValue("value", (Object)"FieldLevel"), annValues.get(0));
    }

    @Test
    public void testClassAnnotations() throws Exception {
        List classAnnotations = this.scanner.getClassAnnotations();
        System.out.println("Class annotations: " + classAnnotations);
        Assert.assertNotNull((Object)classAnnotations);
        Assert.assertEquals((long)1L, (long)classAnnotations.size());
        AnnotationInfo ann = (AnnotationInfo)classAnnotations.get(0);
        Assert.assertEquals((Object)Marker.class.getName(), (Object)ann.getClassName());
        List annValues = ann.getParams();
        Assert.assertNotNull((Object)annValues);
        Assert.assertEquals((long)1L, (long)annValues.size());
        Assert.assertEquals((Object)new AnnotationInfo.NameValue("value", (Object)"ClassLevel"), annValues.get(0));
    }

    @Test
    public void testMethodAnnotations() throws Exception {
        List methodAnnotations = this.scanner.getMethodAnnotations();
        System.out.println("Method annotations: " + methodAnnotations);
        Assert.assertNotNull((Object)methodAnnotations);
        Assert.assertEquals((long)2L, (long)methodAnnotations.size());
        AnnotationInfo ann = (AnnotationInfo)methodAnnotations.get(0);
        Assert.assertEquals((Object)Marker.class.getName(), (Object)ann.getClassName());
        List annValues = ann.getParams();
        Assert.assertNotNull((Object)annValues);
        Assert.assertEquals((long)1L, (long)annValues.size());
        Assert.assertEquals((Object)new AnnotationInfo.NameValue("value", (Object)"MethodLevel / Main"), annValues.get(0));
        ann = (AnnotationInfo)methodAnnotations.get(1);
        Assert.assertEquals((Object)Marker.class.getName(), (Object)ann.getClassName());
        annValues = ann.getParams();
        Assert.assertNotNull((Object)annValues);
        Assert.assertEquals((long)1L, (long)annValues.size());
        Assert.assertEquals((Object)new AnnotationInfo.NameValue("value", (Object)"MethodLevel / toString"), annValues.get(0));
    }
}

