/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.activity;

import java.util.List;
import java.util.Map;
import javax.el.PropertyNotFoundException;
import org.jbpm.api.Execution;
import org.jbpm.api.JbpmException;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.jpdl.internal.activity.JpdlExternalActivity;
import org.jbpm.jpdl.internal.activity.SubProcessInParameterImpl;
import org.jbpm.jpdl.internal.activity.SubProcessOutParameterImpl;
import org.jbpm.pvm.internal.el.Expression;
import org.jbpm.pvm.internal.env.Context;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.env.ExecutionContext;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.model.ScopeInstanceImpl;
import org.jbpm.pvm.internal.session.RepositorySession;
import org.jbpm.pvm.internal.task.SwimlaneImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubProcessActivity
extends JpdlExternalActivity {
    private static final long serialVersionUID = 1L;
    protected String subProcessKey;
    protected String subProcessId;
    protected Map<String, String> swimlaneMappings;
    protected List<SubProcessInParameterImpl> inParameters;
    protected List<SubProcessOutParameterImpl> outParameters;
    protected Expression outcomeExpression;
    protected Map<Object, String> outcomeVariableMappings;

    public void execute(ActivityExecution execution) {
        ExecutionImpl executionImpl = (ExecutionImpl)execution;
        RepositorySession repositorySession = (RepositorySession)EnvironmentImpl.getFromCurrent(RepositorySession.class);
        ProcessDefinitionImpl processDefinition = null;
        if (this.subProcessId != null) {
            Expression subProcessKeyExpression = Expression.create((String)this.subProcessId, (String)"uel-value");
            String subProcessIdEval = (String)subProcessKeyExpression.evaluate((Execution)execution);
            processDefinition = repositorySession.findProcessDefinitionById(subProcessIdEval);
            if (processDefinition == null) {
                throw new JbpmException("cannot find process definition by id: [" + this.subProcessId + "(" + subProcessIdEval + ")" + "]");
            }
        } else {
            String subProcessKeyEval = null;
            try {
                Expression subProcessKeyExpression = Expression.create((String)this.subProcessKey, (String)"uel-value");
                subProcessKeyEval = (String)subProcessKeyExpression.evaluate((Execution)execution);
                if (subProcessKeyEval == null) {
                    throw new JbpmException("Subprocess key '" + this.subProcessKey + "' resolved to null.");
                }
            }
            catch (PropertyNotFoundException e) {
                throw new JbpmException("Subprocess key '" + this.subProcessKey + "' could not be resolved.");
            }
            processDefinition = repositorySession.findProcessDefinitionByKey(subProcessKeyEval);
            if (processDefinition == null) {
                throw new JbpmException("Subprocess '" + subProcessKeyEval + "' could not be found.");
            }
            if (processDefinition == null) {
                throw new JbpmException("cannot find process definition by key: [" + this.subProcessKey + "(" + subProcessKeyEval + ")" + "]");
            }
        }
        ExecutionImpl subProcessInstance = (ExecutionImpl)processDefinition.createProcessInstance(null, (Execution)execution);
        for (String swimlaneName : this.swimlaneMappings.keySet()) {
            String subSwimlaneName = this.swimlaneMappings.get(swimlaneName);
            SwimlaneImpl subSwimlane = subProcessInstance.createSwimlane(subSwimlaneName);
            SwimlaneImpl swimlane = executionImpl.getSwimlane(swimlaneName);
            if (swimlane == null) continue;
            subSwimlane.initialize(swimlane);
        }
        for (SubProcessInParameterImpl inParameter : this.inParameters) {
            inParameter.produce(executionImpl, subProcessInstance);
        }
        executionImpl.historyActivityStart();
        subProcessInstance.start();
        execution.waitForSignal();
    }

    public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) throws Exception {
        this.signal((ExecutionImpl)execution, signalName, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signal(ExecutionImpl execution, String signalName, Map<String, ?> parameters) throws Exception {
        EnvironmentImpl environment;
        ExecutionContext originalExecutionContext;
        String transitionName;
        block12: {
            ExecutionImpl subProcessInstance = execution.getSubProcessInstance();
            transitionName = null;
            originalExecutionContext = null;
            ExecutionContext subProcessExecutionContext = null;
            environment = EnvironmentImpl.getCurrent();
            if (environment != null) {
                originalExecutionContext = (ExecutionContext)environment.removeContext("execution");
                subProcessExecutionContext = new ExecutionContext(subProcessInstance);
                environment.setContext((Context)subProcessExecutionContext);
            }
            try {
                subProcessInstance.setSuperProcessExecution(null);
                execution.setSubProcessInstance(null);
                for (SubProcessOutParameterImpl outParameter : this.outParameters) {
                    outParameter.consume(execution, (ScopeInstanceImpl)subProcessInstance);
                }
                ActivityImpl activity = execution.getActivity();
                String subProcessActivityName = subProcessInstance.getActivityName();
                if (this.outcomeExpression != null) {
                    Object value = this.outcomeExpression.evaluate((Execution)execution);
                    transitionName = value instanceof String && activity.hasOutgoingTransition((String)value) ? (String)value : this.outcomeVariableMappings.get(value);
                } else if (activity.hasOutgoingTransition(subProcessActivityName)) {
                    transitionName = subProcessActivityName;
                }
                if (subProcessExecutionContext == null) break block12;
            }
            catch (Throwable throwable) {
                if (subProcessExecutionContext != null) {
                    environment.removeContext(subProcessExecutionContext);
                }
                if (originalExecutionContext != null) {
                    environment.setContext((Context)originalExecutionContext);
                }
                throw throwable;
            }
            environment.removeContext((Context)subProcessExecutionContext);
        }
        if (originalExecutionContext != null) {
            environment.setContext((Context)originalExecutionContext);
        }
        execution.historyActivityEnd();
        if (transitionName != null) {
            execution.take(transitionName);
        } else {
            execution.takeDefaultTransition();
        }
    }

    public void setSwimlaneMappings(Map<String, String> swimlaneMappings) {
        this.swimlaneMappings = swimlaneMappings;
    }

    public void setOutcomeVariableMappings(Map<Object, String> outcomeVariableMappings) {
        this.outcomeVariableMappings = outcomeVariableMappings;
    }

    public void setSubProcessKey(String subProcessKey) {
        this.subProcessKey = subProcessKey;
    }

    public void setSubProcessId(String subProcessId) {
        this.subProcessId = subProcessId;
    }

    public void setOutcomeExpression(Expression outcomeExpression) {
        this.outcomeExpression = outcomeExpression;
    }

    public List<SubProcessInParameterImpl> getInParameters() {
        return this.inParameters;
    }

    public void setInParameters(List<SubProcessInParameterImpl> inParameters) {
        this.inParameters = inParameters;
    }

    public List<SubProcessOutParameterImpl> getOutParameters() {
        return this.outParameters;
    }

    public void setOutParameters(List<SubProcessOutParameterImpl> outParameters) {
        this.outParameters = outParameters;
    }
}

