/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.StartException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.StopException;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionCallback;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.TransactionTemplate;
import org.mule.transaction.TransactionTemplateFactory;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.ConnectException;
import org.mule.transport.jms.JmsClientAcknowledgeTransaction;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsSupport;
import org.mule.transport.jms.MessageTransactionCallback;
import org.mule.transport.jms.ReusableSessionWrapperFactory;
import org.mule.transport.jms.filters.JmsSelectorFilter;
import org.mule.transport.jms.redelivery.RedeliveryHandler;
import org.mule.util.ClassUtils;

public class TransactedSingleResourceJmsMessageReceiver
extends AbstractMessageReceiver
implements MessageListener {
    protected JmsConnector connector;
    protected RedeliveryHandler redeliveryHandler;
    protected MessageConsumer consumer;
    protected Session session;
    protected boolean startOnConnect = false;
    protected boolean receiveMessagesInTransaction = true;
    protected boolean useMultipleReceivers = true;

    public TransactedSingleResourceJmsMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
        this.connector = (JmsConnector)connector;
        try {
            this.redeliveryHandler = this.connector.getRedeliveryHandlerFactory().create();
            this.redeliveryHandler.setConnector(this.connector);
        }
        catch (Exception e) {
            throw new CreateException((Throwable)e, (Object)this);
        }
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
        try {
            String durableName;
            JmsSupport jmsSupport = this.connector.getJmsSupport();
            if (this.session == null) {
                this.session = this.connector.getSession(this.endpoint);
            }
            boolean topic = this.connector.getTopicResolver().isTopic(this.endpoint);
            Destination dest = jmsSupport.createDestination(this.session, this.endpoint);
            String selector = null;
            JmsSelectorFilter selectorFilter = this.connector.getSelector(this.endpoint);
            if (selectorFilter != null) {
                selector = selectorFilter.getExpression();
            } else if (this.endpoint.getProperties() != null) {
                selector = (String)this.endpoint.getProperties().get("selector");
            }
            String tempDurable = (String)this.endpoint.getProperties().get("durable");
            boolean durable = this.connector.isDurable();
            if (tempDurable != null) {
                durable = Boolean.valueOf(tempDurable);
            }
            if ((durableName = (String)this.endpoint.getProperties().get("durableName")) == null && durable && dest instanceof Topic) {
                durableName = "mule." + this.connector.getName() + "." + this.endpoint.getEndpointURI().getAddress();
                this.logger.debug((Object)("Jms Connector for this receiver is durable but no durable name has been specified. Defaulting to: " + durableName));
            }
            this.consumer = jmsSupport.createConsumer(this.session, dest, selector, this.connector.isNoLocal(), durableName, topic, this.endpoint);
        }
        catch (JMSException e) {
            throw new ConnectException((Throwable)e, (Connectable)this);
        }
    }

    protected void doStart() throws MuleException {
        try {
            if (this.consumer == null) {
                this.startOnConnect = true;
            } else {
                this.startOnConnect = false;
                this.consumer.setMessageListener((MessageListener)this);
            }
        }
        catch (JMSException e) {
            throw new StartException((Throwable)e, (Startable)this);
        }
    }

    protected void doStop() throws MuleException {
        try {
            if (this.consumer != null) {
                this.consumer.setMessageListener(null);
            }
        }
        catch (JMSException e) {
            throw new StopException((Throwable)e, (Stoppable)this);
        }
    }

    public void doDisconnect() throws Exception {
        this.closeConsumer();
    }

    protected void closeConsumer() {
        this.connector.closeQuietly(this.consumer);
        this.consumer = null;
        this.connector.closeQuietly(this.session);
        this.session = null;
    }

    public void onMessage(Message message) {
        try {
            this.processMessages(message, (MessageReceiver)this);
            message.acknowledge();
        }
        catch (MessagingException e) {
            if (e.getEvent().getMessage().getExceptionPayload() != null) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        catch (Exception e) {
            this.getConnector().getMuleContext().getExceptionListener().handleException(e);
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public void processMessages(Message message, final MessageReceiver receiver) throws Exception {
        TransactionTemplate tt = TransactionTemplateFactory.createMainTransactionTemplate((TransactionConfig)this.endpoint.getTransactionConfig(), (MuleContext)this.connector.getMuleContext());
        final String encoding = this.endpoint.getEncoding();
        if (this.receiveMessagesInTransaction) {
            MessageTransactionCallback<Void> cb = new MessageTransactionCallback<Void>(message){

                public Void doInTransaction() throws Exception {
                    Transaction tx = TransactionCoordination.getInstance().getTransaction();
                    if (tx != null) {
                        tx.bindResource((Object)TransactedSingleResourceJmsMessageReceiver.this.connector.getConnection(), (Object)ReusableSessionWrapperFactory.createWrapper(TransactedSingleResourceJmsMessageReceiver.this.session));
                    }
                    if (tx instanceof JmsClientAcknowledgeTransaction) {
                        tx.bindResource((Object)this.message, (Object)this.message);
                    }
                    if (TransactedSingleResourceJmsMessageReceiver.this.logger.isDebugEnabled()) {
                        TransactedSingleResourceJmsMessageReceiver.this.logger.debug((Object)("Message received it is of type: " + ClassUtils.getSimpleName(this.message.getClass())));
                        if (this.message.getJMSDestination() != null) {
                            TransactedSingleResourceJmsMessageReceiver.this.logger.debug((Object)("Message received on " + this.message.getJMSDestination() + " (" + this.message.getJMSDestination().getClass().getName() + ")"));
                        } else {
                            TransactedSingleResourceJmsMessageReceiver.this.logger.debug((Object)"Message received on unknown destination");
                        }
                        TransactedSingleResourceJmsMessageReceiver.this.logger.debug((Object)("Message CorrelationId is: " + this.message.getJMSCorrelationID()));
                        TransactedSingleResourceJmsMessageReceiver.this.logger.debug((Object)("Jms Message Id is: " + this.message.getJMSMessageID()));
                    }
                    if (this.message.getJMSRedelivered()) {
                        if (TransactedSingleResourceJmsMessageReceiver.this.logger.isDebugEnabled()) {
                            TransactedSingleResourceJmsMessageReceiver.this.logger.debug((Object)("Message with correlationId: " + this.message.getJMSCorrelationID() + " is redelivered. handing off to Exception Handler"));
                        }
                        TransactedSingleResourceJmsMessageReceiver.this.redeliveryHandler.handleRedelivery(this.message, receiver.getEndpoint(), receiver.getFlowConstruct());
                    }
                    MuleMessage messageToRoute = TransactedSingleResourceJmsMessageReceiver.this.createMuleMessage(this.message, encoding);
                    TransactedSingleResourceJmsMessageReceiver.this.routeMessage(messageToRoute);
                    return null;
                }
            };
            tt.execute((TransactionCallback)cb);
        } else {
            MuleMessage messageToRoute = this.createMuleMessage(message, encoding);
            this.routeMessage(messageToRoute);
        }
    }
}

