/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.cache;

import org.mule.cache.ObjectStoreCachingStrategy;
import org.mule.cache.keygenerator.ExpressionKeyGenerator;
import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.assembly.BeanAssemblerFactory;
import org.mule.config.spring.parsers.assembly.DefaultBeanAssembler;
import org.mule.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.config.spring.parsers.assembly.configuration.SingleProperty;
import org.mule.config.spring.parsers.generic.OrphanDefinitionParser;
import org.mule.config.spring.parsers.processors.CheckExclusiveAttributes;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;

public class CachingStrategyDefinitionParser
extends OrphanDefinitionParser {
    public CachingStrategyDefinitionParser(Class<ObjectStoreCachingStrategy> objectStoreCachingStrategyClass, boolean singleton) {
        super(objectStoreCachingStrategyClass, singleton);
        this.setBeanAssemblerFactory(new LocalBeanAssemblerFactory());
        this.registerPreProcessor(new CheckExclusiveAttributes(new String[][]{{"keyGenerationExpression"}, {"keyGeneration-ref"}}));
    }

    private class LocalBeanAssemblerFactory
    implements BeanAssemblerFactory {
        private LocalBeanAssemblerFactory() {
        }

        @Override
        public BeanAssembler newBeanAssembler(PropertyConfiguration beanConfig, BeanDefinitionBuilder bean, PropertyConfiguration targetConfig, BeanDefinition target) {
            return new LocalBeanAssembler(beanConfig, bean, targetConfig, target);
        }
    }

    private class LocalBeanAssembler
    extends DefaultBeanAssembler {
        public LocalBeanAssembler(PropertyConfiguration beanConfig, BeanDefinitionBuilder bean, PropertyConfiguration targetConfig, BeanDefinition target) {
            super(beanConfig, bean, targetConfig, target);
        }

        @Override
        protected void addPropertyWithReference(MutablePropertyValues properties, SingleProperty config, String name, Object value) {
            if ("keyGenerationExpression".equals(name)) {
                BeanDefinitionBuilder wrapper = BeanDefinitionBuilder.genericBeanDefinition(ExpressionKeyGenerator.class);
                wrapper.addPropertyValue("expression", value);
                super.addPropertyWithReference(properties, config, "keyGenerator", wrapper.getBeanDefinition());
            } else {
                super.addPropertyWithReference(properties, config, name, value);
            }
        }
    }
}

