/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.transport.AbstractConnector;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.xmpp.XmppConnector;
import org.mule.transport.xmpp.XmppConversation;

public class XmppMessageReceiver
extends AbstractMessageReceiver
implements PacketListener {
    private XmppConversation xmppConversation;

    public XmppMessageReceiver(AbstractConnector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super((Connector)connector, flowConstruct, endpoint);
        XmppConnector xmppConnector = (XmppConnector)connector;
        this.xmppConversation = xmppConnector.getConversationFactory().create((ImmutableEndpoint)endpoint);
    }

    protected void doConnect() throws Exception {
        this.xmppConversation.connect();
    }

    protected void doDisconnect() throws Exception {
        this.xmppConversation.disconnect();
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    protected void doDispose() {
        this.xmppConversation = null;
    }

    protected Work createWork(Packet message) {
        return new XMPPWorker(message);
    }

    public void processPacket(Packet packet) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("processing packet: " + packet.toXML()));
        }
        Work work = this.createWork(packet);
        try {
            this.getWorkManager().scheduleWork(work, Long.MAX_VALUE, null, (WorkListener)this.connector);
        }
        catch (WorkException e) {
            this.logger.error((Object)("Xmpp Server receiver work failed: " + e.getMessage()), (Throwable)e);
        }
    }

    private class XMPPWorker
    implements Work {
        Packet packet = null;

        public XMPPWorker(Packet message) {
            this.packet = message;
        }

        public void run() {
            try {
                MuleMessage message;
                MuleEvent event;
                MuleMessage returnMessage;
                if (XmppMessageReceiver.this.logger.isDebugEnabled()) {
                    XmppMessageReceiver.this.logger.debug((Object)("Processing XMPP packet from: " + this.packet.getFrom()));
                }
                MuleMessage muleMessage = returnMessage = (event = XmppMessageReceiver.this.routeMessage(message = XmppMessageReceiver.this.createMuleMessage(this.packet, XmppMessageReceiver.this.endpoint.getEncoding()))) == null ? null : event.getMessage();
                if (returnMessage != null && this.packet instanceof Message) {
                    returnMessage.applyTransformers(event, XmppMessageReceiver.this.connector.getDefaultResponseTransformers(XmppMessageReceiver.this.endpoint));
                    Packet result = (Packet)returnMessage.getPayload();
                }
            }
            catch (Exception e) {
                XmppMessageReceiver.this.getConnector().getMuleContext().getExceptionListener().handleException(e);
            }
        }

        public void release() {
        }
    }
}

