/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.vm;

import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.config.QueueProfile;
import org.mule.endpoint.DynamicURIInboundEndpoint;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.routing.filters.WildcardFilter;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.XaTransaction;
import org.mule.transport.AbstractConnector;
import org.mule.transport.vm.VMMessageReceiver;
import org.mule.util.queue.QueueManager;
import org.mule.util.queue.QueueSession;
import org.mule.util.xa.XAResourceFactory;

public class VMConnector
extends AbstractConnector {
    public static final String VM = "vm";
    private QueueProfile queueProfile;
    private Integer queueTimeout;
    private QueueManager queueManager;
    private static XAResourceFactory xaResourceFactory;

    public VMConnector(MuleContext context) {
        super(context);
    }

    protected void doInitialise() throws InitialisationException {
        if (this.queueTimeout == null) {
            this.queueTimeout = this.muleContext.getConfiguration().getDefaultQueueTimeout();
        }
        if (this.queueManager == null) {
            this.queueManager = this.getMuleContext().getQueueManager();
        }
        if (this.queueProfile == null) {
            this.queueProfile = QueueProfile.newInstancePersistingToDefaultMemoryQueueStore((MuleContext)this.muleContext);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("created default QueueProfile for VM connector: " + this.queueProfile));
            }
        }
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    public MessageReceiver createReceiver(FlowConstruct flowConstruct, InboundEndpoint endpoint) throws Exception {
        if (!endpoint.getExchangePattern().hasResponse()) {
            this.queueProfile.configureQueue(this.getMuleContext(), endpoint.getEndpointURI().getAddress(), this.queueManager);
        }
        return this.serviceDescriptor.createMessageReceiver((Connector)this, flowConstruct, endpoint);
    }

    public String getProtocol() {
        return "VM";
    }

    public QueueProfile getQueueProfile() {
        return this.queueProfile;
    }

    public void setQueueProfile(QueueProfile queueProfile) {
        this.queueProfile = queueProfile;
    }

    public static void setXaResourceFactory(XAResourceFactory xaResourceFactory) {
        VMConnector.xaResourceFactory = xaResourceFactory;
    }

    VMMessageReceiver getReceiver(EndpointURI endpointUri) throws EndpointException {
        return (VMMessageReceiver)this.getReceiverByEndpoint(endpointUri);
    }

    QueueSession getQueueSession() throws InitialisationException {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx != null && tx.hasResource((Object)this.queueManager)) {
            QueueSession queueSession = (QueueSession)tx.getResource((Object)this.queueManager);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieved VM queue session " + queueSession + " from current transaction " + tx));
            }
            return queueSession;
        }
        QueueSession session = this.queueManager.getQueueSession();
        if (tx != null) {
            try {
                tx.bindResource((Object)this.queueManager, (Object)session);
                if (xaResourceFactory != null && tx instanceof XaTransaction) {
                    tx.bindResource((Object)this, (Object)xaResourceFactory.create());
                }
            }
            catch (TransactionException e) {
                throw new RuntimeException("Could not bind queue session to current transaction", e);
            }
        }
        return session;
    }

    protected MessageReceiver getReceiverByEndpoint(EndpointURI endpointUri) throws EndpointException {
        MessageReceiver receiver2;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking up vm receiver for address: " + endpointUri.toString()));
        }
        if ((receiver2 = (MessageReceiver)this.receivers.get(endpointUri.getAddress())) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found exact receiver match on endpointUri: " + endpointUri));
            }
            return receiver2;
        }
        for (MessageReceiver receiver2 : this.receivers.values()) {
            String filterAddress = receiver2.getEndpointURI().getAddress();
            WildcardFilter filter = new WildcardFilter(filterAddress);
            if (!filter.accept((Object)endpointUri.getAddress())) continue;
            InboundEndpoint endpoint = receiver2.getEndpoint();
            MuleEndpointURI newEndpointURI = new MuleEndpointURI(endpointUri, filterAddress);
            receiver2.setEndpoint((InboundEndpoint)new DynamicURIInboundEndpoint(endpoint, (EndpointURI)newEndpointURI));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found receiver match on endpointUri: " + receiver2.getEndpointURI() + " against " + endpointUri));
            }
            return receiver2;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No receiver found for endpointUri: " + endpointUri));
        }
        return null;
    }

    public boolean isResponseEnabled() {
        return true;
    }

    public int getQueueTimeout() {
        return this.queueTimeout;
    }

    public void setQueueTimeout(int queueTimeout) {
        this.queueTimeout = queueTimeout;
    }

    public QueueManager getQueueManager() {
        return this.queueManager;
    }
}

