/*
 * $Id: InvalidExpressionException.java 20321 2010-11-24 15:21:24Z dfeist $
 * -------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.api.expression;

import org.mule.config.i18n.CoreMessages;

/**
 * Is thrown explicitly when an expression is Malformed or invalid.  Malformed means the syntax is not correct, but an
 * expression can be invalid if it refers to an expression namespace or function that does not exist
 */
public class InvalidExpressionException extends ExpressionRuntimeException
{
    public InvalidExpressionException(String expression, String message)
    {
        super(CoreMessages.createStaticMessage(message + ". Offending expression string is: " + expression));
    }
}
