/*
 * Decompiled with CFR 0.152.
 */
package org.mule.process;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transaction.TransactionException;
import org.mule.process.ProcessingCallback;
import org.mule.process.ProcessingInterceptor;
import org.mule.transaction.TransactionCoordination;

class BeginAndResolveTransactionInterceptor<T>
implements ProcessingInterceptor<T> {
    private static final Log logger = LogFactory.getLog(BeginAndResolveTransactionInterceptor.class);
    private final ProcessingInterceptor<T> next;
    private final TransactionConfig transactionConfig;
    private final MuleContext muleContext;
    private final boolean processOnException;

    BeginAndResolveTransactionInterceptor(ProcessingInterceptor next, TransactionConfig transactionConfig, MuleContext muleContext, boolean processOnException) {
        this.next = next;
        this.transactionConfig = transactionConfig;
        this.muleContext = muleContext;
        this.processOnException = processOnException;
    }

    @Override
    public T execute(ProcessingCallback<T> callback) throws Exception {
        byte action = this.transactionConfig.getAction();
        boolean mustResolveTransaction = false;
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (action == 1 || action == 2 && tx == null) {
            logger.debug((Object)"Beginning transaction");
            tx = this.transactionConfig.getFactory().beginTransaction(this.muleContext);
            mustResolveTransaction = true;
            logger.debug((Object)("Transaction successfully started: " + tx));
        }
        try {
            T result = this.next.execute(callback);
            this.resolveTransactionIfRequired(mustResolveTransaction);
            return result;
        }
        catch (MessagingException e) {
            if (this.processOnException) {
                this.resolveTransactionIfRequired(true);
            }
            throw e;
        }
    }

    private void resolveTransactionIfRequired(boolean mustResolveTransaction) throws TransactionException {
        Transaction transaction = TransactionCoordination.getInstance().getTransaction();
        if (mustResolveTransaction && transaction != null) {
            TransactionCoordination.getInstance().resolveTransaction();
        }
    }
}

