/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.AnnotatedObject;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.TransformerTemplate;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;
import org.mule.util.ClassUtils;
import org.mule.util.TemplateParser;

public class InvokerMessageProcessor
implements MessageProcessor,
Initialisable,
MuleContextAware,
AnnotatedObject {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected Object object;
    protected Class<?> objectType;
    protected String methodName;
    protected List<?> arguments = new ArrayList();
    protected Class<?>[] argumentTypes;
    protected String name;
    protected TemplateParser.PatternInfo patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    protected Method method;
    protected ExpressionManager expressionManager;
    protected MuleContext muleContext;
    private final Map<QName, Object> annotations = new ConcurrentHashMap<QName, Object>();

    @Override
    public void initialise() throws InitialisationException {
        if (this.object == null) {
            this.lookupObjectInstance();
        }
        this.resolveMethodToInvoke();
        this.expressionManager = this.muleContext.getExpressionManager();
    }

    protected void resolveMethodToInvoke() throws InitialisationException {
        if (this.argumentTypes != null) {
            this.method = ClassUtils.getMethod(this.object.getClass(), this.methodName, this.argumentTypes);
            if (this.method == null) {
                throw new InitialisationException(CoreMessages.methodWithParamsNotFoundOnObject(this.methodName, this.argumentTypes, this.object.getClass()), (Initialisable)this);
            }
        } else {
            ArrayList<Method> matchingMethods = new ArrayList<Method>();
            int argSize = this.arguments != null ? this.arguments.size() : 0;
            for (Method methodCandidate : this.object.getClass().getMethods()) {
                if (!methodCandidate.getName().equals(this.methodName) || methodCandidate.getParameterTypes().length != argSize) continue;
                matchingMethods.add(methodCandidate);
            }
            if (matchingMethods.size() == 1) {
                this.method = (Method)matchingMethods.get(0);
                this.argumentTypes = this.method.getParameterTypes();
            } else {
                throw new InitialisationException(CoreMessages.methodWithNumParamsNotFoundOnObject(this.methodName, this.arguments.size(), this.object), (Initialisable)this);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Initialised %s to use method: '%s'", this, this.method));
        }
    }

    protected void lookupObjectInstance() throws InitialisationException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("No object instance speciedied.  Looking up single instance of type %s in mule registry", this.objectType));
        }
        try {
            this.object = this.muleContext.getRegistry().lookupObject(this.objectType);
        }
        catch (RegistrationException e) {
            throw new InitialisationException(CoreMessages.initialisationFailure(String.format("Muliple instances of '%s' were found in the registry so you need to configure a specific instance", this.objectType)), (Initialisable)this);
        }
        if (this.object == null) {
            throw new InitialisationException(CoreMessages.initialisationFailure(String.format("No instance of '%s' was found in the registry", this.objectType)), (Initialisable)this);
        }
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleEvent resultEvent = event;
        Object[] args = this.evaluateArguments(event, this.arguments);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Invoking  '%s' of '%s' with arguments: '%s'", this.method.getName(), this.object, args));
        }
        try {
            Object result = this.method.invoke(this.object, args);
            if (!this.method.getReturnType().equals(Void.TYPE)) {
                resultEvent = this.createResultEvent(event, result);
            }
        }
        catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke(this.object.toString()), event, (Throwable)e);
        }
        return resultEvent;
    }

    protected Object[] evaluateArguments(MuleEvent event, List<?> argumentTemplates) throws MessagingException {
        int argSize = argumentTemplates != null ? argumentTemplates.size() : 0;
        Object[] args = new Object[argSize];
        MuleMessage message = event.getMessage();
        try {
            for (int i = 0; i < args.length; ++i) {
                Object argumentTemplate = argumentTemplates.get(i);
                if (argumentTemplate == null) continue;
                args[i] = this.transformArgument(this.evaluateExpressionCandidate(argumentTemplate, message), this.argumentTypes[i]);
            }
            return args;
        }
        catch (TransformerException e) {
            throw new MessagingException(event, (Throwable)e);
        }
    }

    protected Object evaluateExpressionCandidate(Object expressionCandidate, MuleMessage message) throws TransformerException {
        if (expressionCandidate instanceof Collection) {
            Collection collectionTemplate = (Collection)expressionCandidate;
            ArrayList<Object> newCollection = new ArrayList<Object>();
            for (Object object : collectionTemplate) {
                newCollection.add(this.evaluateExpressionCandidate(object, message));
            }
            return newCollection;
        }
        if (expressionCandidate instanceof Map) {
            Map mapTemplate = (Map)expressionCandidate;
            HashMap<Object, Object> newMap = new HashMap<Object, Object>();
            for (Map.Entry entry : mapTemplate.entrySet()) {
                newMap.put(this.evaluateExpressionCandidate(entry.getKey(), message), this.evaluateExpressionCandidate(entry.getValue(), message));
            }
            return newMap;
        }
        if (expressionCandidate instanceof String[]) {
            String[] stringArrayTemplate = (String[])expressionCandidate;
            String[] newArray = new String[stringArrayTemplate.length];
            for (int j = 0; j < stringArrayTemplate.length; ++j) {
                newArray[j] = this.evaluateExpressionCandidate(stringArrayTemplate[j], message);
            }
            return newArray;
        }
        if (expressionCandidate instanceof String) {
            String expression = (String)expressionCandidate;
            Object arg = expression.startsWith(this.patternInfo.getPrefix()) && expression.endsWith(this.patternInfo.getSuffix()) ? this.expressionManager.evaluate(expression, message) : this.expressionManager.parse(expression, message);
            if (arg instanceof MuleMessage) {
                arg = ((MuleMessage)arg).getPayload();
            }
            return arg;
        }
        return expressionCandidate;
    }

    private Object transformArgument(Object arg, Class<?> type) throws TransformerException {
        if (!type.isAssignableFrom(arg.getClass())) {
            DataType<?> source = DataTypeFactory.create(arg.getClass());
            DataType<?> target = DataTypeFactory.create(type);
            Transformer t = this.muleContext.getRegistry().lookupTransformer(source, target);
            arg = t.transform(arg);
        }
        return arg;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setArgumentExpressionsString(String arguments) {
        this.arguments = Arrays.asList(arguments.split("\\s*,\\s*"));
    }

    public void setArguments(List<?> arguments) {
        this.arguments = arguments;
    }

    protected MuleEvent createResultEvent(MuleEvent event, Object result) throws MuleException {
        if (result instanceof MuleMessage) {
            return new DefaultMuleEvent((MuleMessage)result, event);
        }
        if (result != null) {
            event.getMessage().applyTransformers(event, Collections.singletonList(new TransformerTemplate(new TransformerTemplate.OverwitePayloadCallback(result))));
            return event;
        }
        return new DefaultMuleEvent(new DefaultMuleMessage(NullPayload.getInstance(), event.getMuleContext()), event);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setArgumentTypes(Class<?>[] argumentTypes) {
        this.argumentTypes = argumentTypes;
    }

    public String toString() {
        return String.format("InvokerMessageProcessor [name=%s, object=%s, methodName=%s, argExpressions=%s, argTypes=%s]", this.name, this.object, this.methodName, this.arguments, this.argumentTypes);
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setObjectType(Class<?> objectType) {
        this.objectType = objectType;
    }

    @Override
    public final Object getAnnotation(QName name) {
        return this.annotations.get(name);
    }

    @Override
    public final Map<QName, Object> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    @Override
    public final synchronized void setAnnotations(Map<QName, Object> newAnnotations) {
        this.annotations.clear();
        this.annotations.putAll(newAnnotations);
    }
}

