/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json;

import de.odysseus.staxon.AbstractXMLInputFactory;
import de.odysseus.staxon.event.SimpleXMLEventReader;
import de.odysseus.staxon.event.SimpleXMLFilteredEventReader;
import de.odysseus.staxon.json.JsonXMLStreamReader;
import de.odysseus.staxon.json.stream.JsonStreamFactory;
import de.odysseus.staxon.json.stream.JsonStreamSource;
import de.odysseus.staxon.json.stream.util.AddRootSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import javax.xml.stream.EventFilter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class JsonXMLInputFactory
extends AbstractXMLInputFactory {
    public static final String PROP_MULTIPLE_PI = "JsonXMLInputFactory.multiplePI";
    public static final String PROP_VIRTUAL_ROOT = "JsonXMLInputFactory.virtualRoot";
    private final JsonStreamFactory streamFactory;
    private boolean multiplePI = true;
    private String virtualRoot = null;
    private boolean coalescing = true;

    public JsonXMLInputFactory() throws FactoryConfigurationError {
        this(JsonStreamFactory.newFactory());
    }

    public JsonXMLInputFactory(JsonStreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }

    private JsonStreamSource decorate(JsonStreamSource source) {
        if (this.virtualRoot != null) {
            source = new AddRootSource(source, this.virtualRoot);
        }
        return source;
    }

    @Override
    public XMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
        try {
            return new JsonXMLStreamReader(this.decorate(this.streamFactory.createJsonStreamSource(reader)), this.multiplePI);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public XMLStreamReader createXMLStreamReader(InputStream stream) throws XMLStreamException {
        try {
            return new JsonXMLStreamReader(this.decorate(this.streamFactory.createJsonStreamSource(stream)), this.multiplePI);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public XMLEventReader createXMLEventReader(XMLStreamReader reader) throws XMLStreamException {
        if (this.getEventAllocator() == null) {
            return new SimpleXMLEventReader(reader);
        }
        return new SimpleXMLEventReader(reader, this.getEventAllocator().newInstance());
    }

    @Override
    public XMLEventReader createFilteredReader(XMLEventReader reader, EventFilter filter) throws XMLStreamException {
        return new SimpleXMLFilteredEventReader(reader, filter);
    }

    @Override
    public void setXMLResolver(XMLResolver resolver) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setXMLReporter(XMLReporter reporter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProperty(String name, Object value) throws IllegalArgumentException {
        if ("javax.xml.stream.isCoalescing".equals(name)) {
            this.coalescing = (Boolean)value;
        } else if ("javax.xml.stream.isNamespaceAware".equals(name)) {
            if (!this.getProperty(name).equals(value)) {
                throw new IllegalArgumentException("Cannot change property: " + name);
            }
        } else if ("javax.xml.stream.isReplacingEntityReferences".equals(name)) {
            if (!this.getProperty(name).equals(value)) {
                throw new IllegalArgumentException("Cannot change property: " + name);
            }
        } else if ("javax.xml.stream.isSupportingExternalEntities".equals(name)) {
            if (!this.getProperty(name).equals(value)) {
                throw new IllegalArgumentException("Cannot change property: " + name);
            }
        } else if ("javax.xml.stream.isValidating".equals(name)) {
            if (!this.getProperty(name).equals(value)) {
                throw new IllegalArgumentException("Cannot change property: " + name);
            }
        } else if (PROP_MULTIPLE_PI.equals(name)) {
            this.multiplePI = (Boolean)value;
        } else if (PROP_VIRTUAL_ROOT.equals(name)) {
            this.virtualRoot = (String)value;
        } else {
            throw new IllegalArgumentException("Unsupported property: " + name);
        }
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        if ("javax.xml.stream.isCoalescing".equals(name)) {
            return this.coalescing;
        }
        if ("javax.xml.stream.isNamespaceAware".equals(name)) {
            return Boolean.TRUE;
        }
        if ("javax.xml.stream.isReplacingEntityReferences".equals(name)) {
            return Boolean.TRUE;
        }
        if ("javax.xml.stream.isSupportingExternalEntities".equals(name)) {
            return Boolean.FALSE;
        }
        if ("javax.xml.stream.isValidating".equals(name)) {
            return Boolean.FALSE;
        }
        if (PROP_MULTIPLE_PI.equals(name)) {
            return this.multiplePI;
        }
        if (PROP_VIRTUAL_ROOT.equals(name)) {
            return this.virtualRoot;
        }
        throw new IllegalArgumentException("Unsupported property: " + name);
    }

    @Override
    public boolean isPropertySupported(String name) {
        if ("javax.xml.stream.isCoalescing".equals(name)) {
            return true;
        }
        if ("javax.xml.stream.isNamespaceAware".equals(name)) {
            return true;
        }
        if ("javax.xml.stream.isReplacingEntityReferences".equals(name)) {
            return true;
        }
        if ("javax.xml.stream.isSupportingExternalEntities".equals(name)) {
            return true;
        }
        if ("javax.xml.stream.isValidating".equals(name)) {
            return true;
        }
        return Arrays.asList(PROP_MULTIPLE_PI, PROP_VIRTUAL_ROOT).contains(name);
    }
}

