/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.extractors;

import java.lang.reflect.Method;
import org.drools.RuntimeDroolsException;
import org.drools.base.BaseClassFieldWriter;
import org.drools.base.ValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDoubleClassFieldWriter
extends BaseClassFieldWriter {
    private static final long serialVersionUID = 400L;

    public BaseDoubleClassFieldWriter(Class<?> clazz, String fieldName) {
        super(clazz, fieldName);
    }

    protected BaseDoubleClassFieldWriter(int index, Class<?> fieldType, ValueType valueType) {
        super(index, fieldType, valueType);
    }

    @Override
    public void setValue(Object bean, Object value) {
        this.setDoubleValue(bean, value == null ? 0.0 : ((Number)value).doubleValue());
    }

    @Override
    public void setBooleanValue(Object bean, boolean value) {
        throw new RuntimeDroolsException("Conversion to double not supported from boolean");
    }

    @Override
    public void setByteValue(Object bean, byte value) {
        this.setDoubleValue(bean, value);
    }

    @Override
    public void setCharValue(Object bean, char value) {
        throw new RuntimeDroolsException("Conversion to double not supported from char");
    }

    @Override
    public abstract void setDoubleValue(Object var1, double var2);

    @Override
    public void setFloatValue(Object bean, float value) {
        this.setDoubleValue(bean, value);
    }

    @Override
    public void setIntValue(Object bean, int value) {
        this.setDoubleValue(bean, value);
    }

    @Override
    public void setLongValue(Object bean, long value) {
        this.setDoubleValue(bean, value);
    }

    @Override
    public void setShortValue(Object bean, short value) {
        this.setDoubleValue(bean, value);
    }

    @Override
    public Method getNativeWriteMethod() {
        try {
            return this.getClass().getDeclaredMethod("setDoubleValue", Object.class, Double.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }
}

