/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io.impl;

import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.io.InternalResource;
import org.drools.io.Resource;
import org.drools.io.impl.BaseResource;
import org.drools.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemResource
extends BaseResource
implements InternalResource,
Externalizable {
    private File file;
    private long lastRead = -1L;

    public FileSystemResource() {
    }

    public FileSystemResource(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        this.file = new File(StringUtils.cleanPath(file.getPath()));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.file);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.file = (File)in.readObject();
    }

    public FileSystemResource(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path must not be null");
        }
        this.file = new File(StringUtils.cleanPath(path));
    }

    public InputStream getInputStream() throws IOException {
        this.lastRead = this.getLastModified();
        return new FileInputStream(this.file);
    }

    public Reader getReader() throws IOException {
        return new InputStreamReader(this.getInputStream());
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public Collection<Resource> listResources() {
        File[] files = this.file.listFiles();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (File file : files) {
            resources.add(new FileSystemResource(file));
        }
        return resources;
    }

    @Override
    public URL getURL() throws IOException {
        return this.file.toURI().toURL();
    }

    @Override
    public boolean hasURL() {
        return true;
    }

    @Override
    public long getLastModified() {
        long date = this.file.lastModified();
        return date;
    }

    @Override
    public long getLastRead() {
        return this.lastRead;
    }

    public String toString() {
        return "[FileResource file='" + this.file.toString() + "']";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return object == this || object instanceof FileSystemResource && this.file.equals(((FileSystemResource)object).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

