/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.vm;

import java.io.Serializable;
import org.mule.DefaultMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.NoReceiverForEndpointException;
import org.mule.config.i18n.CoreMessages;
import org.mule.process.ProcessingCallback;
import org.mule.process.TransactionalProcessingTemplate;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.vm.VMConnector;
import org.mule.transport.vm.VMMessageReceiver;
import org.mule.transport.vm.i18n.VMMessages;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueSession;

public class VMMessageDispatcher
extends AbstractMessageDispatcher {
    private final VMConnector connector;

    public VMMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (VMConnector)endpoint.getConnector();
    }

    protected void doDispatch(MuleEvent event) throws Exception {
        EndpointURI endpointUri = this.endpoint.getEndpointURI();
        if (endpointUri == null) {
            throw new DispatchException(CoreMessages.objectIsNull((String)"Endpoint"), event, (MessageProcessor)this.getEndpoint());
        }
        MuleEvent eventToDispatch = DefaultMuleEvent.copy((MuleEvent)event);
        eventToDispatch.clearFlowVariables();
        eventToDispatch.setMessage(eventToDispatch.getMessage().createInboundMessage());
        QueueSession session = this.connector.getQueueSession();
        Queue queue = session.getQueue(endpointUri.getAddress());
        if (!queue.offer((Serializable)eventToDispatch, (long)this.connector.getQueueTimeout())) {
            throw new DispatchException(VMMessages.queueIsFull(queue.getName(), queue.size()), eventToDispatch, (MessageProcessor)this.getEndpoint());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("dispatched MuleEvent on endpointUri: " + endpointUri));
        }
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        final VMMessageReceiver receiver = this.connector.getReceiver(this.endpoint.getEndpointURI());
        if (receiver == null) {
            throw new NoReceiverForEndpointException(VMMessages.noReceiverForEndpoint(this.connector.getName(), this.endpoint.getEndpointURI()));
        }
        MuleEvent eventToSend = DefaultMuleEvent.copy((MuleEvent)event);
        final MuleMessage message = eventToSend.getMessage().createInboundMessage();
        TransactionalProcessingTemplate processingTemplate = new TransactionalProcessingTemplate(event.getMuleContext(), receiver.getEndpoint().getTransactionConfig());
        ProcessingCallback<MuleMessage> processingCallback = new ProcessingCallback<MuleMessage>(){

            public MuleMessage process() throws Exception {
                return receiver.onCall(message);
            }
        };
        MuleMessage retMessage = (MuleMessage)processingTemplate.execute((ProcessingCallback)processingCallback);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("sent event on endpointUri: " + this.endpoint.getEndpointURI()));
        }
        if (retMessage != null) {
            retMessage = retMessage.createInboundMessage();
        }
        return retMessage;
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
        if (!this.endpoint.getExchangePattern().hasResponse()) {
            this.connector.getQueueProfile().configureQueue(this.connector.getMuleContext(), this.endpoint.getEndpointURI().getAddress(), this.connector.getQueueManager());
        }
    }

    protected void doDisconnect() throws Exception {
    }
}

