/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.management.mbean;

import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.management.stats.RouterStatistics;
import org.mule.management.stats.ServiceStatistics;
import org.mule.module.management.mbean.FlowConstructStats;
import org.mule.module.management.mbean.RouterStats;
import org.mule.module.management.mbean.ServiceStatsMBean;

public class ServiceStats
extends FlowConstructStats
implements ServiceStatsMBean,
MBeanRegistration {
    private static Log LOGGER = LogFactory.getLog(ServiceStats.class);
    private ObjectName inboundName;
    private ObjectName outboundName;
    private final ServiceStatistics statistics;

    public ServiceStats(ServiceStatistics statistics) {
        super((FlowConstructStatistics)statistics);
        this.statistics = statistics;
    }

    @Override
    public long getAsyncEventsSent() {
        return this.statistics.getAsyncEventsSent();
    }

    @Override
    public long getAverageExecutionTime() {
        return this.statistics.getAverageExecutionTime();
    }

    @Override
    public long getAverageQueueSize() {
        return this.statistics.getAverageQueueSize();
    }

    @Override
    public long getExecutedEvents() {
        return this.statistics.getExecutedEvents();
    }

    @Override
    public long getMaxExecutionTime() {
        return this.statistics.getMaxExecutionTime();
    }

    @Override
    public long getMaxQueueSize() {
        return this.statistics.getMaxQueueSize();
    }

    @Override
    public long getMinExecutionTime() {
        return this.statistics.getMinExecutionTime();
    }

    public String getName() {
        return this.statistics.getName();
    }

    @Override
    public long getQueuedEvents() {
        return this.statistics.getQueuedEvents();
    }

    @Override
    public long getReplyToEventsSent() {
        return this.statistics.getReplyToEventsSent();
    }

    @Override
    public long getSyncEventsSent() {
        return this.statistics.getSyncEventsSent();
    }

    @Override
    public long getTotalEventsSent() {
        return this.statistics.getTotalEventsSent();
    }

    @Override
    public long getTotalExecutionTime() {
        return this.statistics.getTotalExecutionTime();
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return super.preRegister(server, name);
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        super.postRegister(registrationDone);
        try {
            RouterStatistics os;
            RouterStatistics is = this.statistics.getInboundRouterStat();
            if (is != null) {
                String quotedStatsName = ObjectName.quote(this.statistics.getName());
                this.inboundName = new ObjectName(this.name.getDomain() + ":type=org.mule.Statistics,service=" + quotedStatsName + ",router=inbound");
                if (this.server.isRegistered(this.inboundName)) {
                    this.server.unregisterMBean(this.inboundName);
                }
                this.server.registerMBean(new RouterStats(is), this.inboundName);
            }
            if ((os = this.statistics.getOutboundRouterStat()) != null) {
                String quotedStatsName = ObjectName.quote(this.statistics.getName());
                this.outboundName = new ObjectName(this.name.getDomain() + ":type=org.mule.Statistics,service=" + quotedStatsName + ",router=outbound");
                if (this.server.isRegistered(this.outboundName)) {
                    this.server.unregisterMBean(this.outboundName);
                }
                this.server.registerMBean(new RouterStats(os), this.outboundName);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error post-registering MBean", (Throwable)e);
        }
    }

    @Override
    public void preDeregister() throws Exception {
        super.preDeregister();
    }

    @Override
    public void postDeregister() {
        super.postDeregister();
        try {
            if (this.server.isRegistered(this.inboundName)) {
                this.server.unregisterMBean(this.inboundName);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Error unregistering ServiceStats child " + this.inboundName.getCanonicalName()), (Throwable)ex);
        }
        try {
            if (this.server.isRegistered(this.outboundName)) {
                this.server.unregisterMBean(this.outboundName);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Error unregistering ServiceStats child " + this.inboundName.getCanonicalName()), (Throwable)ex);
        }
    }

    public ObjectName getRouterInbound() {
        return this.inboundName;
    }

    public ObjectName getRouterOutbound() {
        return this.outboundName;
    }
}

