/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.provider.tangosol;

import com.tangosol.net.NamedCache;
import java.beans.PropertyEditor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.springframework.beans.propertyeditors.StringArrayPropertyEditor;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springmodules.cache.CacheException;
import org.springmodules.cache.CachingModel;
import org.springmodules.cache.FatalCacheException;
import org.springmodules.cache.FlushingModel;
import org.springmodules.cache.provider.AbstractCacheProviderFacade;
import org.springmodules.cache.provider.CacheModelValidator;
import org.springmodules.cache.provider.ReflectionCacheModelEditor;
import org.springmodules.cache.provider.tangosol.CoherenceCachingModel;
import org.springmodules.cache.provider.tangosol.CoherenceFlushingModel;
import org.springmodules.cache.provider.tangosol.CoherenceModelValidator;

public class CoherenceFacade
extends AbstractCacheProviderFacade {
    private static final String CACHE_FACTORY_CLASS_NAME = "com.tangosol.net.CacheFactory";
    private static final String GET_CACHE_METHOD_NAME = "getCache";
    private final Method getCacheMethod;
    private CacheModelValidator cacheModelValidator;

    public CoherenceFacade() {
        try {
            Class clazz = ClassUtils.forName((String)CACHE_FACTORY_CLASS_NAME);
            this.getCacheMethod = ReflectionUtils.findMethod((Class)clazz, (String)GET_CACHE_METHOD_NAME, (Class[])new Class[]{String.class});
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize CoherenceFacade because Tangosol API classes are not available: " + ex);
        }
        this.cacheModelValidator = new CoherenceModelValidator();
    }

    public CacheModelValidator modelValidator() {
        return this.cacheModelValidator;
    }

    public PropertyEditor getCachingModelEditor() {
        ReflectionCacheModelEditor editor = new ReflectionCacheModelEditor();
        editor.setCacheModelClass(CoherenceCachingModel.class);
        return editor;
    }

    public PropertyEditor getFlushingModelEditor() {
        HashMap<String, StringArrayPropertyEditor> propertyEditors = new HashMap<String, StringArrayPropertyEditor>();
        propertyEditors.put("cacheNames", new StringArrayPropertyEditor());
        ReflectionCacheModelEditor editor = new ReflectionCacheModelEditor();
        editor.setCacheModelClass(CoherenceFlushingModel.class);
        editor.setCacheModelPropertyEditors(propertyEditors);
        return editor;
    }

    protected boolean isSerializableCacheElementRequired() {
        return false;
    }

    protected void onFlushCache(FlushingModel model) throws CacheException {
        CoherenceFlushingModel coherenceFlushingModel = (CoherenceFlushingModel)model;
        Object[] cacheNames = coherenceFlushingModel.getCacheNames();
        if (!ObjectUtils.isEmpty((Object[])cacheNames)) {
            int count = cacheNames.length;
            for (int i = 0; i < count; ++i) {
                this.getCache((String)cacheNames[0]).clear();
            }
        }
    }

    protected Object onGetFromCache(Serializable key, CachingModel model) throws CacheException {
        NamedCache cache = this.getCache(model);
        return cache.get((Object)key);
    }

    protected void onPutInCache(Serializable key, CachingModel model, Object obj) throws CacheException {
        CoherenceCachingModel coherenceCachingModel = (CoherenceCachingModel)model;
        String name = coherenceCachingModel.getCacheName();
        NamedCache cache = this.getCache(name);
        Long timeToLive = coherenceCachingModel.getTimeToLive();
        if (timeToLive != null) {
            cache.put((Object)key, obj, timeToLive.longValue());
        } else {
            cache.put((Object)key, obj);
        }
    }

    protected void onRemoveFromCache(Serializable key, CachingModel model) throws CacheException {
        NamedCache cache = this.getCache(model);
        cache.remove((Object)key);
    }

    protected void validateCacheManager() throws FatalCacheException {
    }

    private NamedCache getCache(CachingModel model) {
        CoherenceCachingModel coherenceCachingModel = (CoherenceCachingModel)model;
        String name = coherenceCachingModel.getCacheName();
        return this.getCache(name);
    }

    private NamedCache getCache(String name) {
        return (NamedCache)ReflectionUtils.invokeMethod((Method)this.getCacheMethod, null, (Object[])new String[]{name});
    }
}

