/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.serializable;

import com.thoughtworks.xstream.XStream;
import java.io.Serializable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springmodules.cache.serializable.SerializableFactory;
import org.springmodules.util.Objects;

public class XStreamSerializableFactory
implements SerializableFactory {
    private XStream xstream = new XStream();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof XStreamSerializableFactory;
    }

    public Object getOriginalValue(Object obj) {
        if (!(obj instanceof ObjectWrapper)) {
            return obj;
        }
        String value = (String)((Object)((ObjectWrapper)obj).getValue());
        return this.xstream.fromXML(value);
    }

    public int hashCode() {
        return 3982;
    }

    public Serializable makeSerializableIfNecessary(Object obj) {
        if (obj == null || obj instanceof Serializable) {
            return (Serializable)obj;
        }
        String value = this.xstream.toXML(obj);
        return new ObjectWrapper((Serializable)((Object)value));
    }

    public static class ObjectWrapper
    implements Serializable {
        private static final long serialVersionUID = -1308206556015427863L;
        private Serializable value;

        public ObjectWrapper() {
        }

        public ObjectWrapper(Serializable value) {
            this.setValue(value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ObjectWrapper)) {
                return false;
            }
            ObjectWrapper wrapper = (ObjectWrapper)obj;
            return ObjectUtils.nullSafeEquals((Object)this.value, (Object)wrapper.value);
        }

        public Serializable getValue() {
            return this.value;
        }

        public int hashCode() {
            int multiplier = 31;
            int hash = 17;
            hash = multiplier * hash + Objects.nullSafeHashCode(this.value);
            return hash;
        }

        public void setValue(Serializable value) {
            this.value = value;
        }

        public String toString() {
            return Objects.identityToString(this).append("[value=").append(StringUtils.quoteIfString((Object)this.value)).append(']').toString();
        }
    }
}

