/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.util.Collections;
import java.util.Map;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.http.HttpPollingConnector;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.util.MapUtils;

public class PollingHttpMessageReceiver
extends AbstractPollingMessageReceiver {
    protected String etag = null;
    protected boolean checkEtag;
    protected boolean discardEmptyContent;
    private OutboundEndpoint outboundEndpoint;

    public PollingHttpMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
        this.setupFromConnector(connector);
    }

    protected void setupFromConnector(Connector connector) throws CreateException {
        if (!(connector instanceof HttpPollingConnector)) {
            throw new CreateException(HttpMessages.pollingReciverCannotbeUsed(), (Object)this);
        }
        HttpPollingConnector pollingConnector = (HttpPollingConnector)connector;
        long pollingFrequency = MapUtils.getLongValue((Map)this.endpoint.getProperties(), (Object)"pollingFrequency", (long)pollingConnector.getPollingFrequency());
        if (pollingFrequency > 0L) {
            this.setFrequency(pollingFrequency);
        }
        this.checkEtag = MapUtils.getBooleanValue((Map)this.endpoint.getProperties(), (Object)"checkEtag", (boolean)pollingConnector.isCheckEtag());
        this.discardEmptyContent = MapUtils.getBooleanValue((Map)this.endpoint.getProperties(), (Object)"discardEmptyContent", (boolean)pollingConnector.isDiscardEmptyContent());
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    public void doDisconnect() throws Exception {
    }

    public void poll() throws Exception {
        int contentLength;
        MuleContext muleContext = this.connector.getMuleContext();
        if (this.outboundEndpoint == null) {
            EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(this.endpoint);
            endpointBuilder.setMessageProcessors(Collections.emptyList());
            endpointBuilder.setResponseMessageProcessors(Collections.emptyList());
            endpointBuilder.setMessageProcessors(Collections.emptyList());
            endpointBuilder.setResponseMessageProcessors(Collections.emptyList());
            endpointBuilder.setExchangePattern(MessageExchangePattern.REQUEST_RESPONSE);
            this.outboundEndpoint = muleContext.getEndpointFactory().getOutboundEndpoint((EndpointBuilder)endpointBuilder);
        }
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"", this.outboundEndpoint.getProperties(), muleContext);
        if (this.etag != null && this.checkEtag) {
            request.setOutboundProperty("If-None-Match", (Object)this.etag);
        }
        request.setOutboundProperty("http.method", (Object)"GET");
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)request, this.outboundEndpoint.getExchangePattern(), this.flowConstruct);
        MuleEvent result = this.outboundEndpoint.process((MuleEvent)event);
        MuleMessage message = null;
        if (result != null) {
            message = result.getMessage();
        }
        if ((contentLength = ((Integer)message.getOutboundProperty("Content-Length", (Object)-1)).intValue()) == 0 && this.discardEmptyContent) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Received empty message and ignoring from: " + this.endpoint.getEndpointURI()));
            }
            return;
        }
        int status = (Integer)message.getOutboundProperty("http.status", (Object)0);
        this.etag = (String)message.getOutboundProperty("ETag");
        if (status != 304 || !this.checkEtag) {
            this.routeMessage(message);
        }
    }
}

