/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextException;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.RoutingException;
import org.mule.config.i18n.MessageFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ExceptionsTestCase
extends AbstractMuleTestCase {
    @Test
    public void testExceptionChaining() {
        String rootMsg = "Root Test Exception Message";
        String msg = "Test Exception Message";
        MuleContextException e = new MuleContextException(MessageFactory.createStaticMessage((String)msg), (Throwable)new DefaultMuleException(MessageFactory.createStaticMessage((String)rootMsg)));
        Assert.assertEquals((Object)rootMsg, (Object)e.getCause().getMessage());
        Assert.assertEquals((Object)msg, (Object)e.getMessage());
        Assert.assertEquals((Object)(e.getClass().getName() + ": " + msg), (Object)e.toString());
    }

    @Test
    public final void testRoutingExceptionNullMessageValidEndpoint() throws MuleException {
        OutboundEndpoint endpoint = (OutboundEndpoint)Mockito.mock(OutboundEndpoint.class);
        RoutingException rex = new RoutingException(null, (MessageProcessor)endpoint);
        Assert.assertSame((Object)endpoint, (Object)rex.getRoute());
    }
}

