/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.outbound;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.registry.ServiceException;
import org.mule.api.registry.ServiceType;
import org.mule.api.routing.filter.Filter;
import org.mule.api.security.SecurityFilter;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.MessageDispatcher;
import org.mule.endpoint.AbstractMessageProcessorTestCase;
import org.mule.endpoint.DynamicOutboundEndpoint;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.security.TestSecurityFilter;
import org.mule.tck.testmodels.mule.TestMessageDispatcher;
import org.mule.tck.testmodels.mule.TestMessageDispatcherFactory;
import org.mule.transformer.simple.OutboundAppendTransformer;
import org.mule.transformer.simple.ResponseAppendTransformer;
import org.mule.transport.service.DefaultTransportServiceDescriptor;

public class DynamicOutboundEndpointTestCase
extends AbstractMessageProcessorTestCase {
    private MuleEvent testOutboundEvent;

    @Before
    public void setCurrentTestInstance() throws ServiceException {
        this.overrideDispatcherInServiceDescriptor();
        MyMessageDispatcherFactory.dispatcher = null;
    }

    @Test
    public void testDefaultFlowRequestResponse() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent();
        MuleEvent result = endpoint.process(this.testOutboundEvent);
        this.assertEventSent();
        Assert.assertNotSame((Object)responseMessage, (Object)result.getMessage());
        this.assertMessageEqualEncodingPropertyAdded(responseMessage, result.getMessage());
    }

    @Test
    public void testDefaultFlowOneWay() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.ONE_WAY, null);
        Assert.assertTrue((boolean)(endpoint instanceof DynamicOutboundEndpoint));
        this.testOutboundEvent = this.createTestOutboundEvent();
        MuleEvent result = endpoint.process(this.testOutboundEvent);
        this.assertEventDispatched();
        Assert.assertNull((Object)result);
        this.assertMessageSentEqual(MyMessageDispatcherFactory.dispatcher.sensedDispatchEvent);
    }

    @Test
    public void testSecurityFilterAccept() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, (SecurityFilter)new TestSecurityFilter(true), null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent();
        MuleEvent result = endpoint.process(this.testOutboundEvent);
        this.assertEventSent();
        this.assertMessageSentEqual(MyMessageDispatcherFactory.dispatcher.sensedSendEvent);
        Assert.assertNotSame((Object)responseMessage, (Object)result.getMessage());
        this.assertMessageEqualEncodingPropertyAdded(responseMessage, result.getMessage());
    }

    @Test
    public void testSecurityFilterNotAccept() throws Exception {
        AbstractMessageProcessorTestCase.TestSecurityNotificationListener securityNotificationListener = new AbstractMessageProcessorTestCase.TestSecurityNotificationListener();
        muleContext.registerListener((ServerNotificationListener)securityNotificationListener);
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, (SecurityFilter)new TestSecurityFilter(false), null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent();
        try {
            endpoint.process(this.testOutboundEvent);
            Assert.fail((String)"Exception expected");
        }
        catch (TestSecurityFilter.StaticMessageUnauthorisedException e) {
            this.testOutboundEvent.getFlowConstruct().getExceptionListener().handleException((Exception)((Object)e), this.testOutboundEvent);
        }
        Assert.assertNull((Object)((Object)MyMessageDispatcherFactory.dispatcher));
        Assert.assertTrue((boolean)securityNotificationListener.latch.await(5000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)401L, (long)securityNotificationListener.securityNotification.getAction());
        Assert.assertEquals((Object)securityNotificationListener.securityNotification.getResourceIdentifier(), (Object)TestSecurityFilter.StaticMessageUnauthorisedException.class.getName());
    }

    @Test
    public void testSendNotification() throws Exception {
        AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener listener = new AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener(2);
        muleContext.registerListener((ServerNotificationListener)listener);
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        MuleEvent outboundEvent = this.createTestOutboundEvent();
        endpoint.process(outboundEvent);
        this.assertEventSent();
        Assert.assertTrue((boolean)listener.latch.await(5000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)2L, (long)listener.messageNotificationList.size());
        Assert.assertEquals((long)803L, (long)listener.messageNotificationList.get(0).getAction());
        Assert.assertEquals((long)852L, (long)listener.messageNotificationList.get(1).getAction());
        Assert.assertTrue((boolean)(listener.messageNotificationList.get(0).getSource() instanceof MuleMessage));
        Assert.assertTrue((boolean)(listener.messageNotificationList.get(1).getSource() instanceof MuleMessage));
        Assert.assertEquals((Object)outboundEvent.getMessage().getPayload(), (Object)listener.messageNotificationList.get(0).getSource().getPayload());
        Assert.assertEquals((Object)RESPONSE_MESSAGE, (Object)listener.messageNotificationList.get(1).getSource().getPayload());
    }

    @Test
    public void testDispatchNotification() throws Exception {
        AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener listener = new AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener(2);
        muleContext.registerListener((ServerNotificationListener)listener);
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.ONE_WAY, null);
        MuleEvent outboundEvent = this.createTestOutboundEvent();
        endpoint.process(outboundEvent);
        this.assertEventDispatched();
        Assert.assertTrue((boolean)listener.latch.await(5000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)2L, (long)listener.messageNotificationList.size());
        Assert.assertEquals((long)802L, (long)listener.messageNotificationList.get(0).getAction());
        Assert.assertEquals((long)851L, (long)listener.messageNotificationList.get(1).getAction());
        Assert.assertTrue((boolean)(listener.messageNotificationList.get(0).getSource() instanceof MuleMessage));
        Assert.assertTrue((boolean)(listener.messageNotificationList.get(1).getSource() instanceof MuleMessage));
        Assert.assertEquals((Object)outboundEvent.getMessage().getPayload(), (Object)listener.messageNotificationList.get(0).getSource().getPayload());
        Assert.assertEquals((Object)outboundEvent.getMessage().getPayload(), (Object)listener.messageNotificationList.get(1).getSource().getPayload());
    }

    @Test
    public void testTransformers() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, (Transformer)new OutboundAppendTransformer(), (Transformer)new ResponseAppendTransformer(), MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent();
        MuleEvent result = endpoint.process(this.testOutboundEvent);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)("Test Message" + OutboundAppendTransformer.APPEND_STRING), (Object)MyMessageDispatcherFactory.dispatcher.sensedSendEvent.getMessageAsString());
        Assert.assertEquals((Object)(RESPONSE_MESSAGE + ResponseAppendTransformer.APPEND_STRING), (Object)result.getMessageAsString());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testConnectorNotAvailableOnDynamicEndpoint() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        endpoint.getConnector();
    }

    @Test
    public void testTimeoutSetOnEvent() throws Exception {
        int testTimeout = 999;
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent();
        this.testOutboundEvent.getMessage().setOutboundProperty("MULE_EVENT_TIMEOUT", (Object)testTimeout);
        MuleEvent response = endpoint.process(this.testOutboundEvent);
        Assert.assertEquals((long)testTimeout, (long)response.getTimeout());
    }

    @Test
    public void testTransaction() {
    }

    @Test
    public void testExceptionHandling() {
    }

    protected void assertMessageSentEqual(MuleEvent event) throws MuleException {
        Assert.assertEquals((Object)"Test Message", (Object)event.getMessageAsString());
        Assert.assertEquals((Object)"value1", (Object)event.getMessage().getOutboundProperty("prop1"));
    }

    protected void assertMessageEqualEncodingPropertyAdded(MuleMessage expect, MuleMessage actual) {
        Assert.assertEquals((Object)expect.getPayload(), (Object)actual.getPayload());
        Assert.assertEquals((Object)expect.getEncoding(), (Object)actual.getEncoding());
        Assert.assertEquals((Object)expect.getUniqueId(), (Object)actual.getUniqueId());
        Assert.assertEquals((Object)expect.getExceptionPayload(), (Object)actual.getExceptionPayload());
        Assert.assertEquals((Object)muleContext.getConfiguration().getDefaultEncoding(), (Object)actual.getOutboundProperty("MULE_ENCODING"));
    }

    private void assertEventDispatched() {
        PollingProber prober = new PollingProber();
        prober.check(new Probe(){

            @Override
            public boolean isSatisfied() {
                return MyMessageDispatcherFactory.dispatcher != null && MyMessageDispatcherFactory.dispatcher.dispatchedEvent;
            }

            @Override
            public String describeFailure() {
                return "Expected dispatcher was not called";
            }
        });
        Assert.assertNull((Object)MyMessageDispatcherFactory.dispatcher.sensedSendEvent);
        Assert.assertNotNull((Object)MyMessageDispatcherFactory.dispatcher.sensedDispatchEvent);
        Assert.assertNotNull((Object)MyMessageDispatcherFactory.dispatcher.sensedDispatchEvent.getMessage());
    }

    private void assertEventSent() {
        PollingProber prober = new PollingProber();
        prober.check(new Probe(){

            @Override
            public boolean isSatisfied() {
                return MyMessageDispatcherFactory.dispatcher != null && MyMessageDispatcherFactory.dispatcher.sentEvent;
            }

            @Override
            public String describeFailure() {
                return "Expected dispatcher was not called";
            }
        });
        Assert.assertNull((Object)MyMessageDispatcherFactory.dispatcher.sensedDispatchEvent);
        Assert.assertNotNull((Object)MyMessageDispatcherFactory.dispatcher.sensedSendEvent);
        Assert.assertNotNull((Object)MyMessageDispatcherFactory.dispatcher.sensedSendEvent.getMessage());
    }

    private void overrideDispatcherInServiceDescriptor() throws ServiceException {
        Properties props = new Properties();
        props.put("dispatcher.factory", MyMessageDispatcherFactory.class.getName());
        DefaultTransportServiceDescriptor serviceDescriptor = (DefaultTransportServiceDescriptor)muleContext.getRegistry().lookupServiceDescriptor(ServiceType.TRANSPORT, "test", null);
        props.put("inbound.exchange.patterns", "ONE_WAY, REQUEST_RESPONSE");
        props.put("outbound.exchange.patterns", "ONE_WAY, REQUEST_RESPONSE");
        serviceDescriptor.setOverrides(props);
    }

    protected OutboundEndpoint createOutboundEndpoint(Filter filter, SecurityFilter securityFilter, Transformer in, Transformer response, MessageExchangePattern exchangePattern, TransactionConfig txConfig) throws Exception {
        return this.createTestOutboundEndpoint("test://localhost:#[header:port]", filter, securityFilter, in, response, exchangePattern, txConfig);
    }

    public static class MyMessageDispatcherFactory
    extends TestMessageDispatcherFactory {
        static FakeMessageDispatcher dispatcher;

        @Override
        public synchronized MessageDispatcher create(OutboundEndpoint ep) throws MuleException {
            if (dispatcher != null) {
                throw new IllegalStateException("Dispatcher for this test was already created");
            }
            dispatcher = new FakeMessageDispatcher(ep);
            return dispatcher;
        }
    }

    private static class FakeMessageDispatcher
    extends TestMessageDispatcher {
        private MuleEvent sensedSendEvent;
        private MuleEvent sensedDispatchEvent;
        private boolean sentEvent;
        private boolean dispatchedEvent;

        public FakeMessageDispatcher(OutboundEndpoint endpoint) {
            super(endpoint);
        }

        @Override
        protected MuleMessage doSend(MuleEvent event) throws Exception {
            this.sensedSendEvent = event;
            this.sentEvent = true;
            return responseMessage;
        }

        @Override
        protected void doDispatch(MuleEvent event) throws Exception {
            this.sensedDispatchEvent = event;
            this.dispatchedEvent = true;
        }
    }
}

