/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.expression.ExceptionTypeExpressionEvaluator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ExceptionTypeExpressionEvaluatorTestCase
extends AbstractMuleTestCase {
    private ExceptionTypeExpressionEvaluator exceptionTypeExpressionEvaluator = new ExceptionTypeExpressionEvaluator();
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleMessage mockMuleMessage;

    @Test
    public void testEvaluateNotMatchingExpression() throws Exception {
        Assert.assertThat((Object)((Boolean)this.exceptionTypeExpressionEvaluator.evaluate("asdf", this.mockMuleMessage)), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testEvaluateMatchingExceptionType() throws Exception {
        this.configureExceptionPayload(new NullPointerException());
        Assert.assertThat((Object)((Boolean)this.exceptionTypeExpressionEvaluator.evaluate(NullPointerException.class.getName(), this.mockMuleMessage)), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testEvaluateMatchingSubtype() throws Exception {
        this.configureExceptionPayload(new NullPointerException());
        Assert.assertThat((Object)((Boolean)this.exceptionTypeExpressionEvaluator.evaluate(RuntimeException.class.getName(), this.mockMuleMessage)), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testEvaluateExactMatchingType() throws Exception {
        this.configureExceptionPayload(new NullPointerException());
        Assert.assertThat((Object)((Boolean)this.exceptionTypeExpressionEvaluator.evaluate("=" + NullPointerException.class.getName(), this.mockMuleMessage)), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testEvaluateExactSubtype() throws Exception {
        this.configureExceptionPayload(new NullPointerException());
        Assert.assertThat((Object)((Boolean)this.exceptionTypeExpressionEvaluator.evaluate("=" + RuntimeException.class.getName(), this.mockMuleMessage)), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testEvaluateMatchingUsingRegex() throws Exception {
        this.configureExceptionPayload((Exception)((Object)new MuleRuntimeException((Throwable)new Exception())));
        Assert.assertThat((Object)((Boolean)this.exceptionTypeExpressionEvaluator.evaluate("(.*).mule.(.*)Exception", this.mockMuleMessage)), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testEvaluateNotMatchingUsingRegex() throws Exception {
        this.configureExceptionPayload(new NullPointerException());
        Assert.assertThat((Object)((Boolean)this.exceptionTypeExpressionEvaluator.evaluate("(.*).mule.not.matching.(.*)Exception", this.mockMuleMessage)), (Matcher)Is.is((Object)false));
    }

    private void configureExceptionPayload(Exception e) {
        Mockito.when((Object)this.mockMuleMessage.getExceptionPayload().getException()).thenReturn((Object)e);
    }
}

