/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.expression.ExpressionConfig;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class ExpressionConfigTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testConfig() throws Exception {
        ExpressionConfig config = new ExpressionConfig("foo=bar", "header", null, "$[", "]");
        config.validate(muleContext.getExpressionManager());
        Assert.assertEquals((Object)"$[header:foo=bar]", (Object)config.getFullExpression(muleContext.getExpressionManager()));
        config = new ExpressionConfig("foo,bar", "headers", null);
        config.validate(muleContext.getExpressionManager());
        Assert.assertEquals((Object)"#[headers:foo,bar]", (Object)config.getFullExpression(muleContext.getExpressionManager()));
        config = new ExpressionConfig();
        config.parse("#[attachment:baz]");
        config.validate(muleContext.getExpressionManager());
        Assert.assertEquals((Object)"attachment", (Object)config.getEvaluator());
        Assert.assertEquals((Object)"baz", (Object)config.getExpression());
        Assert.assertNull((Object)config.getCustomEvaluator());
    }

    @Test
    public void testCustomConfig() throws Exception {
        muleContext.getExpressionManager().registerEvaluator(new ExpressionEvaluator(){

            public Object evaluate(String expression, MuleMessage message) {
                return null;
            }

            public void setName(String name) {
            }

            public String getName() {
                return "customEval";
            }
        });
        ExpressionConfig config = new ExpressionConfig("foo,bar", "custom", "customEval");
        config.validate(muleContext.getExpressionManager());
        Assert.assertEquals((Object)"#[customEval:foo,bar]", (Object)config.getFullExpression(muleContext.getExpressionManager()));
    }
}

