/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.sql.Timestamp;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transformer.simple.StringAppendTransformer;

public class ExpressionManagerTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        Object o = muleContext.getExpressionManager().evaluate("function:uuid", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        o = muleContext.getExpressionManager().evaluate("function:now", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        Assert.assertTrue((boolean)(o instanceof Timestamp));
    }

    @Test
    public void testRegistration() throws Exception {
        try {
            muleContext.getExpressionManager().registerEvaluator(null);
            Assert.fail((String)"null extractor");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertNull((Object)muleContext.getExpressionManager().unregisterEvaluator(null));
    }

    @Test
    public void testValidator() throws Exception {
        Assert.assertFalse((boolean)muleContext.getExpressionManager().isValidExpression("http://${bean:user}:${bean:password}@${header:host}:${header:port}/foo/bar"));
        Assert.assertFalse((boolean)muleContext.getExpressionManager().isValidExpression("${bean:user}"));
        Assert.assertTrue((boolean)muleContext.getExpressionManager().isValidExpression("#[bean:user]"));
        Assert.assertTrue((boolean)muleContext.getExpressionManager().isValidExpression("http://#[bean:user]:#[bean:password]@#[header:host]:#[header:port]/foo/bar"));
        Assert.assertFalse((boolean)muleContext.getExpressionManager().isValidExpression("{bean:user}"));
        Assert.assertFalse((boolean)muleContext.getExpressionManager().isValidExpression("#{bean:user"));
        Assert.assertFalse((boolean)muleContext.getExpressionManager().isValidExpression("user"));
        Assert.assertFalse((boolean)muleContext.getExpressionManager().isValidExpression("http://#[bean:user:#[bean:password]@#[header:host]:#[header:port]/foo/bar"));
        Assert.assertFalse((boolean)muleContext.getExpressionManager().isValidExpression("http://#[bean:user]:##[bean:password]@#[header:host]:#[header:port]/foo/bar"));
        Assert.assertFalse((boolean)muleContext.getExpressionManager().isValidExpression("http://#[bean:user]]:##[bean:password]@#[header:host]:#[header:port]/foo/bar"));
        Assert.assertFalse((boolean)muleContext.getExpressionManager().isValidExpression("http://#[bean:user]:#[[bean:password]@#[header:host]:#[header:port]/foo/bar"));
        Assert.assertTrue((boolean)muleContext.getExpressionManager().isValidExpression("http://#[bean:user]:#[#bean:password]@#[header:host]:#[header:port]/foo/bar"));
    }

    @Test
    public void testParsing() throws Exception {
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"test", muleContext);
        msg.setOutboundProperty("user", (Object)"vasya");
        msg.setOutboundProperty("password", (Object)"pupkin");
        msg.setOutboundProperty("host", (Object)"example.com");
        msg.setOutboundProperty("port", (Object)"12345");
        String result = muleContext.getExpressionManager().parse("http://#[header:user]:#[header:password]@#[header:host]:#[header:port]/foo/bar", (MuleMessage)msg);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"http://vasya:pupkin@example.com:12345/foo/bar", (Object)result);
    }

    @Test
    public void testNestedParsing() throws Exception {
        muleContext.getRegistry().registerObject("proc1", (Object)new StringAppendTransformer("c"));
        muleContext.getRegistry().registerObject("proc2", (Object)new StringAppendTransformer("e"));
        MuleEvent event = ExpressionManagerTestCase.getTestEvent("b");
        RequestContext.setEvent((MuleEvent)event);
        Assert.assertEquals((Object)"-1-abcde-2-", (Object)muleContext.getExpressionManager().parse("-#[string:1]-#[process:proc2:#[string:a#[process:proc1]d]]-#[string:2]-", event.getMessage()));
    }

    @Test
    public void testBooleanEvaluation() {
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"test", muleContext);
        msg.setOutboundProperty("user", (Object)"vasya");
        msg.setOutboundProperty("password", (Object)"pupkin");
        msg.setOutboundProperty("host", (Object)"example.com");
        msg.setOutboundProperty("port", (Object)"12345");
        Assert.assertFalse((boolean)muleContext.getExpressionManager().evaluateBoolean("header:user", (MuleMessage)msg));
        Assert.assertTrue((boolean)muleContext.getExpressionManager().evaluateBoolean("header:user", (MuleMessage)msg, false, true));
        Assert.assertFalse((boolean)muleContext.getExpressionManager().evaluateBoolean("header:user", (MuleMessage)msg, false, false));
        Assert.assertFalse((boolean)muleContext.getExpressionManager().evaluateBoolean("header:ur", (MuleMessage)msg));
        Assert.assertTrue((boolean)muleContext.getExpressionManager().evaluateBoolean("header:ur", (MuleMessage)msg, true, false));
        Assert.assertFalse((boolean)muleContext.getExpressionManager().evaluateBoolean("header:ur", (MuleMessage)msg, false, false));
        Assert.assertTrue((boolean)muleContext.getExpressionManager().evaluateBoolean("string:true", (MuleMessage)msg));
        Assert.assertFalse((boolean)muleContext.getExpressionManager().evaluateBoolean("string:false", (MuleMessage)msg));
    }
}

