/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.config.MuleConfiguration;
import org.mule.expression.RegexExpressionEvaluator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class RegexExpressionEvaluatorTestCase
extends AbstractMuleTestCase {
    private RegexExpressionEvaluator regexExpressionEvaluator;
    private MuleContext muleContext;

    @Before
    public void setUp() throws Exception {
        MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)muleConfiguration.isCacheMessageAsBytes()).thenReturn((Object)false);
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)muleConfiguration);
        this.regexExpressionEvaluator = new RegexExpressionEvaluator();
    }

    @Test
    public void testReturnNullWhenDoesNotMatches() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"TEST", this.muleContext);
        Object result = this.regexExpressionEvaluator.evaluate("TESTw+TEST", (MuleMessage)message);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testReturnsPayloadWhenMatchesIfNoCaptureGroupDefined() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"TESTfooTEST", this.muleContext);
        Object result = this.regexExpressionEvaluator.evaluate("TEST\\w+TEST", (MuleMessage)message);
        Assert.assertEquals((Object)"TESTfooTEST", (Object)result);
    }

    @Test
    public void testReturnsMatchedValueIfCaptureGroupDefined() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"TESTfooTEST", this.muleContext);
        Object result = this.regexExpressionEvaluator.evaluate("TEST(\\w+)TEST", (MuleMessage)message);
        Assert.assertEquals((Object)"foo", (Object)result);
    }

    @Test
    public void testReturnsMultipleValuesIfMultipleCaptureGroupDefine() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"TESTfooTESTbar", this.muleContext);
        Object result = this.regexExpressionEvaluator.evaluate("TEST(\\w+)TEST(\\w+)", (MuleMessage)message);
        Assert.assertTrue((boolean)(result instanceof String[]));
        String[] values = (String[])result;
        Assert.assertEquals((long)2L, (long)values.length);
        Assert.assertEquals((Object)"foo", (Object)values[0]);
        Assert.assertEquals((Object)"bar", (Object)values[1]);
    }
}

