/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import java.io.IOException;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleMessage;
import org.mule.message.DefaultExceptionPayload;
import org.mule.routing.filters.ExpressionFilter;
import org.mule.routing.filters.RegExFilter;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;

public class ExpressionFilterTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testHeaderFilter() throws Exception {
        ExpressionFilter filter = new ExpressionFilter("header", "foo=bar");
        filter.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        Assert.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.setOutboundProperty("foo", (Object)"bar");
        Assert.assertTrue((boolean)filter.accept((MuleMessage)message));
    }

    @Test
    public void testVariableFilter() throws Exception {
        ExpressionFilter filter = new ExpressionFilter("variable", "foo=bar");
        filter.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        Assert.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.setInvocationProperty("foo", (Object)"bar");
        Assert.assertTrue((boolean)filter.accept((MuleMessage)message));
    }

    @Test
    public void testHeaderFilterWithNot() throws Exception {
        ExpressionFilter filter = new ExpressionFilter("header", "foo!=bar");
        filter.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        Assert.assertTrue((boolean)filter.accept((MuleMessage)message));
        message.setOutboundProperty("foo", (Object)"bar");
        Assert.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.setOutboundProperty("foo", (Object)"car");
        Assert.assertTrue((boolean)filter.accept((MuleMessage)message));
    }

    @Test
    public void testVariableFilterWithNot() throws Exception {
        ExpressionFilter filter = new ExpressionFilter("variable", "foo!=bar");
        filter.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        Assert.assertTrue((boolean)filter.accept((MuleMessage)message));
        message.setInvocationProperty("foo", (Object)"bar");
        Assert.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.setInvocationProperty("foo", (Object)"car");
        Assert.assertTrue((boolean)filter.accept((MuleMessage)message));
    }

    @Test
    public void testHeaderFilterWithNotNull() throws Exception {
        ExpressionFilter filter = new ExpressionFilter("header", "foo!=null");
        filter.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        Assert.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.removeProperty("foo");
        Assert.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.setOutboundProperty("foo", (Object)"car");
        Assert.assertTrue((boolean)filter.accept((MuleMessage)message));
    }

    @Test
    public void testVariableFilterWithNotNull() throws Exception {
        ExpressionFilter filter = new ExpressionFilter("variable", "foo!=null");
        filter.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        Assert.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.removeProperty("foo");
        Assert.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.setInvocationProperty("foo", (Object)"car");
        Assert.assertTrue((boolean)filter.accept((MuleMessage)message));
    }

    @Test
    public void testRegexFilterNoPattern() {
        RegExFilter filter = new RegExFilter();
        Assert.assertNull((Object)filter.getPattern());
        Assert.assertFalse((boolean)filter.accept((Object)"No tengo dinero"));
        filter.setPattern("(.*) brown fox");
        Assert.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        filter.setPattern(null);
        Assert.assertFalse((boolean)filter.accept((Object)"oh-oh"));
    }

    @Test
    public void testRegexFilter() {
        ExpressionFilter filter = new ExpressionFilter("regex", "The quick (.*)");
        filter.setMuleContext(muleContext);
        Assert.assertNotNull((Object)filter.getExpression());
        Assert.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"The quick brown fox", muleContext)));
        Assert.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"The quick ", muleContext)));
        Assert.assertTrue((!filter.accept((MuleMessage)new DefaultMuleMessage((Object)"The quickbrown fox", muleContext)) ? 1 : 0) != 0);
        Assert.assertTrue((!filter.accept((MuleMessage)new DefaultMuleMessage((Object)"he quick brown fox", muleContext)) ? 1 : 0) != 0);
    }

    @Test
    public void testRegexFilterWithAngleBrackets() {
        ExpressionFilter filter = new ExpressionFilter("#[regex:The number is [1-9]]");
        filter.setMuleContext(muleContext);
        Assert.assertNotNull((Object)filter.getExpression());
        Assert.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"The number is 4", muleContext)));
        Assert.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"Say again?", muleContext)));
        Assert.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"The number is 0", muleContext)));
    }

    @Test
    public void testExceptionTypeFilter() {
        ExpressionFilter filter = new ExpressionFilter("exception-type:java.lang.Exception");
        filter.setMuleContext(muleContext);
        DefaultMuleMessage m = new DefaultMuleMessage((Object)"test", muleContext);
        Assert.assertTrue((!filter.accept((MuleMessage)m) ? 1 : 0) != 0);
        m.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new IllegalArgumentException("test")));
        Assert.assertTrue((boolean)filter.accept((MuleMessage)m));
        filter = new ExpressionFilter("exception-type:java.io.IOException");
        Assert.assertTrue((!filter.accept((MuleMessage)m) ? 1 : 0) != 0);
        m.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new IOException("test")));
        Assert.assertTrue((boolean)filter.accept((MuleMessage)m));
    }

    @Test
    public void testPayloadTypeFilter() {
        ExpressionFilter filter = new ExpressionFilter("payload-type:org.mule.tck.testmodels.fruit.Apple");
        filter.setMuleContext(muleContext);
        Assert.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)new Apple(), muleContext)));
        Assert.assertTrue((!filter.accept((MuleMessage)new DefaultMuleMessage((Object)"test", muleContext)) ? 1 : 0) != 0);
        filter = new ExpressionFilter("payload-type:java.lang.String");
        Assert.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"test", muleContext)));
        Assert.assertTrue((!filter.accept((MuleMessage)new DefaultMuleMessage((Object)new Exception("test"), muleContext)) ? 1 : 0) != 0);
    }

    @Test
    public void testWildcardFilterMultiplePatterns() {
        ExpressionFilter filter = new ExpressionFilter("wildcard:* brown*, The*");
        filter.setMuleContext(muleContext);
        Assert.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"The quick brown fox", muleContext)));
        Assert.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)" brown fox", muleContext)));
        Assert.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"The quickbrown fox", muleContext)));
    }

    @Test
    public void testTrueString() {
        ExpressionFilter filter = new ExpressionFilter("payload:");
        filter.setMuleContext(muleContext);
        filter.setNullReturnsTrue(true);
        Assert.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"true", muleContext)));
        Assert.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"TRUE", muleContext)));
        Assert.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"tRuE", muleContext)));
    }

    @Test
    public void testFalseString() {
        ExpressionFilter filter = new ExpressionFilter("payload:");
        filter.setMuleContext(muleContext);
        filter.setNullReturnsTrue(false);
        Assert.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"false", muleContext)));
        Assert.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"FALSE", muleContext)));
        Assert.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"faLSe", muleContext)));
    }

    @Test
    public void testExpressionFilter() {
        ExpressionFilter filter = new ExpressionFilter("mule:message.header(foo?)");
        filter.setMuleContext(muleContext);
        filter.setNullReturnsTrue(false);
        Assert.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"x", muleContext)));
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("foo", "bar");
        Assert.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"x", headers, muleContext)));
    }

    @Test
    public void testExpressionFilterWithFullSyntax() {
        ExpressionFilter filter = new ExpressionFilter("#[mule:message.header(foo?)]");
        filter.setMuleContext(muleContext);
        filter.setNullReturnsTrue(false);
        Assert.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"x", muleContext)));
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("foo", "bar");
        Assert.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"x", headers, muleContext)));
    }
}

