/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.resource.spi.work.WorkListener;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleSession;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextBuilder;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.routing.filter.Filter;
import org.mule.api.service.Service;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.builders.DefaultsConfigurationBuilder;
import org.mule.config.builders.SimpleConfigurationBuilder;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.context.notification.MuleContextNotification;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.TestingWorkListener;
import org.mule.tck.TriggerableMessageSource;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.util.ClassUtils;
import org.mule.util.FileUtils;
import org.mule.util.concurrent.Latch;

public abstract class AbstractMuleContextTestCase
extends AbstractMuleTestCase {
    public static final String[] IGNORED_DOT_MULE_DIRS = new String[]{"transaction-log"};
    public static final String CLASSNAME_ANNOTATIONS_CONFIG_BUILDER = "org.mule.config.AnnotationsConfigurationBuilder";
    protected static MuleContext muleContext;
    private boolean startContext = false;
    public static final String TEST_MESSAGE = "Test Message";
    public static final long LOCK_TIMEOUT = 30000L;
    public static final int RECEIVE_TIMEOUT = 5000;
    protected Latch callbackCalled;
    private boolean disposeContextPerClass;

    protected boolean isDisposeContextPerClass() {
        return this.disposeContextPerClass;
    }

    protected void setDisposeContextPerClass(boolean val) {
        this.disposeContextPerClass = val;
    }

    @Before
    public final void setUpMuleContext() throws Exception {
        muleContext = this.createMuleContext();
        if (this.isStartContext() && muleContext != null && !muleContext.isStarted()) {
            this.startMuleContext();
        }
        this.doSetUp();
    }

    private void startMuleContext() throws MuleException, InterruptedException {
        final AtomicReference<Latch> contextStartedLatch = new AtomicReference<Latch>();
        contextStartedLatch.set(new Latch());
        muleContext.registerListener((ServerNotificationListener)new MuleContextNotificationListener<MuleContextNotification>(){

            public void onNotification(MuleContextNotification notification) {
                if (notification.getAction() == 104) {
                    ((Latch)contextStartedLatch.get()).countDown();
                }
            }
        });
        muleContext.start();
        ((Latch)contextStartedLatch.get()).await(20L, TimeUnit.SECONDS);
    }

    protected void doSetUp() throws Exception {
    }

    protected MuleContext createMuleContext() throws Exception {
        MuleContext context;
        if (this.isDisposeContextPerClass() && muleContext != null) {
            context = muleContext;
        } else {
            DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
            ArrayList<ConfigurationBuilder> builders = new ArrayList<ConfigurationBuilder>();
            builders.add((ConfigurationBuilder)new SimpleConfigurationBuilder((Map)this.getStartUpProperties()));
            if (ClassUtils.isClassOnPath((String)CLASSNAME_ANNOTATIONS_CONFIG_BUILDER, this.getClass())) {
                builders.add((ConfigurationBuilder)ClassUtils.instanciateClass((String)CLASSNAME_ANNOTATIONS_CONFIG_BUILDER, (Object[])ClassUtils.NO_ARGS, this.getClass()));
            }
            builders.add(this.getBuilder());
            this.addBuilders(builders);
            DefaultMuleContextBuilder contextBuilder = new DefaultMuleContextBuilder();
            this.configureMuleContext((MuleContextBuilder)contextBuilder);
            context = muleContextFactory.createMuleContext(builders, (MuleContextBuilder)contextBuilder);
            if (!this.isGracefulShutdown()) {
                ((DefaultMuleConfiguration)context.getConfiguration()).setShutdownTimeout(0);
            }
        }
        return context;
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
    }

    protected void configureMuleContext(MuleContextBuilder contextBuilder) {
        contextBuilder.setWorkListener((WorkListener)new TestingWorkListener());
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        return new DefaultsConfigurationBuilder();
    }

    protected String getConfigurationResources() {
        return "";
    }

    protected Properties getStartUpProperties() {
        return null;
    }

    @After
    public final void disposeContextPerTest() throws Exception {
        this.doTearDown();
        if (!this.isDisposeContextPerClass()) {
            AbstractMuleContextTestCase.disposeContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void disposeContext() {
        try {
            if (muleContext != null && !muleContext.isDisposed() && !muleContext.isDisposing()) {
                muleContext.dispose();
                MuleConfiguration configuration = muleContext.getConfiguration();
                if (configuration != null) {
                    String workingDir = configuration.getWorkingDirectory();
                    FileUtils.deleteTree((File)FileUtils.newFile((String)workingDir), (String[])IGNORED_DOT_MULE_DIRS);
                }
            }
            FileUtils.deleteTree((File)FileUtils.newFile((String)"./ActiveMQ"));
        }
        finally {
            muleContext = null;
        }
    }

    protected void doTearDown() throws Exception {
    }

    public static InboundEndpoint getTestInboundEndpoint(String name) throws Exception {
        return MuleTestUtils.getTestInboundEndpoint(name, muleContext);
    }

    public static OutboundEndpoint getTestOutboundEndpoint(String name) throws Exception {
        return MuleTestUtils.getTestOutboundEndpoint(name, muleContext);
    }

    public static InboundEndpoint getTestInboundEndpoint(MessageExchangePattern mep) throws Exception {
        return MuleTestUtils.getTestInboundEndpoint(mep, muleContext);
    }

    public static InboundEndpoint getTestTransactedInboundEndpoint(MessageExchangePattern mep) throws Exception {
        return MuleTestUtils.getTestTransactedInboundEndpoint(mep, muleContext);
    }

    public static InboundEndpoint getTestInboundEndpoint(String name, String uri) throws Exception {
        return MuleTestUtils.getTestInboundEndpoint(name, muleContext, uri, null, null, null, null);
    }

    public static OutboundEndpoint getTestOutboundEndpoint(String name, String uri) throws Exception {
        return MuleTestUtils.getTestOutboundEndpoint(name, muleContext, uri, null, null, null);
    }

    public static InboundEndpoint getTestInboundEndpoint(String name, List<Transformer> transformers) throws Exception {
        return MuleTestUtils.getTestInboundEndpoint(name, muleContext, null, transformers, null, null, null);
    }

    public static OutboundEndpoint getTestOutboundEndpoint(String name, List<Transformer> transformers) throws Exception {
        return MuleTestUtils.getTestOutboundEndpoint(name, muleContext, null, transformers, null, null);
    }

    public static InboundEndpoint getTestInboundEndpoint(String name, String uri, List<Transformer> transformers, Filter filter, Map<Object, Object> properties, Connector connector) throws Exception {
        return MuleTestUtils.getTestInboundEndpoint(name, muleContext, uri, transformers, filter, properties, connector);
    }

    public static OutboundEndpoint getTestOutboundEndpoint(String name, String uri, List<Transformer> transformers, Filter filter, Map<Object, Object> properties) throws Exception {
        return MuleTestUtils.getTestOutboundEndpoint(name, muleContext, uri, transformers, filter, properties);
    }

    public static OutboundEndpoint getTestOutboundEndpoint(String name, String uri, List<Transformer> transformers, Filter filter, Map<Object, Object> properties, Connector connector) throws Exception {
        return MuleTestUtils.getTestOutboundEndpoint(name, muleContext, uri, transformers, filter, properties, connector);
    }

    public static MuleEvent getTestEvent(Object data, FlowConstruct service) throws Exception {
        return MuleTestUtils.getTestEvent(data, service, MessageExchangePattern.REQUEST_RESPONSE, muleContext);
    }

    public static MuleEvent getTestEvent(Object data, FlowConstruct service, MessageExchangePattern mep) throws Exception {
        return MuleTestUtils.getTestEvent(data, service, mep, muleContext);
    }

    public static MuleEvent getTestEvent(Object data) throws Exception {
        return MuleTestUtils.getTestEvent(data, MessageExchangePattern.REQUEST_RESPONSE, muleContext);
    }

    public static MuleEvent getTestEventUsingFlow(Object data) throws Exception {
        return MuleTestUtils.getTestEventUsingFlow(data, MessageExchangePattern.REQUEST_RESPONSE, muleContext);
    }

    public static MuleEvent getTestEvent(Object data, MessageExchangePattern mep) throws Exception {
        return MuleTestUtils.getTestEvent(data, mep, muleContext);
    }

    public static MuleEvent getTestEvent(Object data, MuleSession session) throws Exception {
        return MuleTestUtils.getTestEvent(data, session, muleContext);
    }

    public static MuleEventContext getTestEventContext(Object data) throws Exception {
        return MuleTestUtils.getTestEventContext(data, MessageExchangePattern.REQUEST_RESPONSE, muleContext);
    }

    public static MuleEventContext getTestEventContext(Object data, MessageExchangePattern mep) throws Exception {
        return MuleTestUtils.getTestEventContext(data, mep, muleContext);
    }

    public static Transformer getTestTransformer() throws Exception {
        return MuleTestUtils.getTestTransformer();
    }

    public static MuleEvent getTestEvent(Object data, InboundEndpoint endpoint) throws Exception {
        return MuleTestUtils.getTestEvent(data, endpoint, muleContext);
    }

    public static MuleEvent getTestEvent(Object data, Service service, InboundEndpoint endpoint) throws Exception {
        return MuleTestUtils.getTestEvent(data, (FlowConstruct)service, endpoint, muleContext);
    }

    public static MuleSession getTestSession(Service service, MuleContext context) {
        return MuleTestUtils.getTestSession((FlowConstruct)service, context);
    }

    public static TestConnector getTestConnector() throws Exception {
        return MuleTestUtils.getTestConnector(muleContext);
    }

    public static Service getTestService() throws Exception {
        return MuleTestUtils.getTestService(muleContext);
    }

    public static Service getTestService(String name, Class<?> clazz) throws Exception {
        return MuleTestUtils.getTestService(name, clazz, muleContext);
    }

    public static Service getTestService(String name, Class<?> clazz, Map<?, ?> props) throws Exception {
        return MuleTestUtils.getTestService(name, clazz, props, muleContext);
    }

    protected boolean isStartContext() {
        return this.startContext;
    }

    protected void setStartContext(boolean startContext) {
        this.startContext = startContext;
    }

    protected boolean isGracefulShutdown() {
        return false;
    }

    protected <T> T createObject(Class<T> clazz) throws Exception {
        return this.createObject(clazz, ClassUtils.NO_ARGS);
    }

    protected <T> T createObject(Class<T> clazz, Object ... args) throws Exception {
        if (args == null) {
            args = ClassUtils.NO_ARGS;
        }
        Object o = ClassUtils.instanciateClass(clazz, (Object[])args);
        muleContext.getRegistry().registerObject(String.valueOf(o.hashCode()), o);
        return (T)o;
    }

    protected void initialiseObject(Object o) throws RegistrationException {
        muleContext.getRegistry().registerObject(String.valueOf(o.hashCode()), o);
    }

    public SensingNullMessageProcessor getSensingNullMessageProcessor() {
        return new SensingNullMessageProcessor();
    }

    public TriggerableMessageSource getTriggerableMessageSource(MessageProcessor listener) {
        return new TriggerableMessageSource(listener);
    }

    public TriggerableMessageSource getTriggerableMessageSource() {
        return new TriggerableMessageSource();
    }
}

