/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ibeans.config;

import java.io.IOException;
import java.util.HashSet;
import org.ibeans.annotation.Call;
import org.ibeans.annotation.IBeanGroup;
import org.ibeans.annotation.Template;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationException;
import org.mule.module.ibeans.config.AbstractAnnotationConfigurationBuilder;
import org.mule.module.ibeans.config.IBeanHolder;
import org.mule.util.scan.ClasspathScanner;

public class IBeanHolderConfigurationBuilder
extends AbstractAnnotationConfigurationBuilder {
    public static final String IBEAN_HOLDER_PREFIX = "_ibeanHolder.";

    public IBeanHolderConfigurationBuilder() {
    }

    public IBeanHolderConfigurationBuilder(String ... basepackages) {
        super(basepackages);
    }

    public IBeanHolderConfigurationBuilder(ClassLoader classLoader) {
        super(classLoader);
    }

    public IBeanHolderConfigurationBuilder(ClassLoader classLoader, String ... basepackages) {
        super(classLoader, basepackages);
    }

    @Override
    protected String getScanPackagesProperty() {
        return "ibeans.scan.packages";
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        HashSet ibeanClasses = new HashSet();
        ClasspathScanner scanner = this.createClasspathScanner();
        try {
            ibeanClasses.addAll(scanner.scanFor(Call.class, 2));
            ibeanClasses.addAll(scanner.scanFor(Template.class, 2));
            ibeanClasses.addAll(scanner.scanFor(IBeanGroup.class, 2));
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
        for (Class ibeanClass : ibeanClasses) {
            muleContext.getRegistry().registerObject(IBeanHolder.getId(ibeanClass), (Object)new IBeanHolder(ibeanClass));
        }
    }
}

