/*
 * $Id: NoArgsEntryPointResolverTestCase.java 22422 2011-07-15 08:22:16Z dirk.olmes $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.test.integration.resolvers;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Test;
import org.junit.runners.Parameterized.Parameters;

public class NoArgsEntryPointResolverTestCase extends AbstractEntryPointResolverTestCase
{
    @Parameters
    public static Collection<Object[]> parameters()
    {
        return Arrays.asList(new Object[][]{
            {ConfigVariant.SERVICE, "org/mule/test/integration/resolvers/no-args-entry-point-resolver-test-service.xml"},
            {ConfigVariant.FLOW, "org/mule/test/integration/resolvers/no-args-entry-point-resolver-test-flow.xml"}
        });
    }      
    
    public NoArgsEntryPointResolverTestCase(ConfigVariant variant, String configResources)
    {
        super(variant, configResources);
    }

    @Test
    public void testIgnored() throws Exception
    {
        doTest("not-ignored", new Object(), "notIgnored");
    }

    @Test
    public void testSelected() throws Exception
    {
        doTest("selected", new Object(), "selected");
    }
}
