/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.MaskFunctor;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.graph.SimpleGraph;
import org.jgrapht.graph.UndirectedMaskSubgraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockCutpointGraph<V, E>
extends SimpleGraph<UndirectedGraph<V, E>, DefaultEdge> {
    private static final long serialVersionUID = -9101341117013163934L;
    private Set<V> cutpoints = new HashSet<V>();
    private DirectedGraph<V, DefaultEdge> dfsTree;
    private UndirectedGraph<V, E> graph;
    private int numOrder;
    private Stack<BCGEdge> stack = new Stack();
    private Map<V, Set<UndirectedGraph<V, E>>> vertex2biconnectedSubgraphs = new HashMap<V, Set<UndirectedGraph<V, E>>>();
    private Map<V, UndirectedGraph<V, E>> vertex2block = new HashMap<V, UndirectedGraph<V, E>>();
    private Map<V, Integer> vertex2numOrder = new HashMap<V, Integer>();

    public BlockCutpointGraph(UndirectedGraph<V, E> undirectedGraph) {
        super(DefaultEdge.class);
        this.graph = undirectedGraph;
        this.dfsTree = new SimpleDirectedGraph(DefaultEdge.class);
        Object v = undirectedGraph.vertexSet().iterator().next();
        this.dfsTree.addVertex(v);
        this.dfsVisit(v, v);
        if (this.dfsTree.edgesOf(v).size() > 1) {
            this.cutpoints.add(v);
        } else {
            this.cutpoints.remove(v);
        }
        for (V v2 : this.cutpoints) {
            SimpleGraph simpleGraph = new SimpleGraph(this.graph.getEdgeFactory());
            simpleGraph.addVertex(v2);
            this.vertex2block.put(v2, simpleGraph);
            this.addVertex(simpleGraph);
            Set<UndirectedGraph<V, E>> set = this.getBiconnectedSubgraphs(v2);
            for (UndirectedGraph<V, E> undirectedGraph2 : set) {
                assert (this.vertexSet().contains(undirectedGraph2));
                this.addEdge(simpleGraph, undirectedGraph2);
            }
        }
    }

    public UndirectedGraph<V, E> getBlock(V v) {
        if (!this.graph.vertexSet().contains(v)) {
            throw new IllegalArgumentException("No such vertex in the graph!");
        }
        return this.vertex2block.get(v);
    }

    public Set<V> getCutpoints() {
        return this.cutpoints;
    }

    public boolean isCutpoint(V v) {
        if (!this.graph.vertexSet().contains(v)) {
            throw new IllegalArgumentException("No such vertex in the graph!");
        }
        return this.cutpoints.contains(v);
    }

    private void biconnectedComponentFinished(V v, V v2) {
        this.cutpoints.add(v);
        HashSet hashSet = new HashSet();
        HashSet<BCGEdge> hashSet2 = new HashSet<BCGEdge>();
        BCGEdge bCGEdge = this.stack.pop();
        while (this.getNumOrder(bCGEdge.getSource()) >= this.getNumOrder(v2) && !this.stack.isEmpty()) {
            hashSet2.add(bCGEdge);
            hashSet.add(bCGEdge.getSource());
            hashSet.add(bCGEdge.getTarget());
            bCGEdge = this.stack.pop();
        }
        hashSet2.add(bCGEdge);
        hashSet.add(bCGEdge.getSource());
        hashSet.add(bCGEdge.getTarget());
        VertexComponentForbiddenFunction vertexComponentForbiddenFunction = new VertexComponentForbiddenFunction(hashSet);
        UndirectedMaskSubgraph<V, E> undirectedMaskSubgraph = new UndirectedMaskSubgraph<V, E>(this.graph, vertexComponentForbiddenFunction);
        for (Object e : hashSet) {
            this.vertex2block.put((UndirectedMaskSubgraph<V, E>)e, (UndirectedGraph<UndirectedMaskSubgraph<V, E>, E>)undirectedMaskSubgraph);
            this.getBiconnectedSubgraphs(e).add(undirectedMaskSubgraph);
        }
        this.addVertex(undirectedMaskSubgraph);
    }

    private int dfsVisit(V v, V v2) {
        ++this.numOrder;
        int n = this.numOrder;
        this.setNumOrder(v, this.numOrder);
        for (Object e : this.graph.edgesOf(v)) {
            BCGEdge bCGEdge;
            V v3 = Graphs.getOppositeVertex(this.graph, e, v);
            if (this.getNumOrder(v3) == 0) {
                this.dfsTree.addVertex(v3);
                bCGEdge = new BCGEdge(v, v3);
                this.dfsTree.addEdge(v, v3, bCGEdge);
                this.stack.push(bCGEdge);
                int n2 = this.dfsVisit(v3, v);
                n = Math.min(n2, n);
                if (n2 < this.getNumOrder(v)) continue;
                this.biconnectedComponentFinished(v, v3);
                continue;
            }
            if (this.getNumOrder(v3) >= this.getNumOrder(v) || v3.equals(v2)) continue;
            bCGEdge = new BCGEdge(v, v3);
            this.stack.push(bCGEdge);
            n = Math.min(this.getNumOrder(v3), n);
        }
        return n;
    }

    private Set<UndirectedGraph<V, E>> getBiconnectedSubgraphs(V v) {
        Set<UndirectedGraph<V, E>> set = this.vertex2biconnectedSubgraphs.get(v);
        if (set == null) {
            set = new HashSet<UndirectedGraph<V, E>>();
            this.vertex2biconnectedSubgraphs.put((Set<UndirectedGraph<V, E>>)v, (Set<UndirectedGraph<Set<UndirectedGraph<V, E>>, E>>)set);
        }
        return set;
    }

    private int getNumOrder(V v) {
        assert (v != null);
        Integer n = this.vertex2numOrder.get(v);
        if (n == null) {
            return 0;
        }
        return n;
    }

    private void setNumOrder(V v, int n) {
        this.vertex2numOrder.put((Integer)v, n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VertexComponentForbiddenFunction
    implements MaskFunctor<V, E> {
        private Set<V> vertexComponent;

        public VertexComponentForbiddenFunction(Set<V> set) {
            this.vertexComponent = set;
        }

        @Override
        public boolean isEdgeMasked(E e) {
            return false;
        }

        @Override
        public boolean isVertexMasked(V v) {
            return !this.vertexComponent.contains(v);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BCGEdge
    extends DefaultEdge {
        private static final long serialVersionUID = -5115006161815760059L;
        private V source;
        private V target;

        public BCGEdge(V v, V v2) {
            this.source = v;
            this.target = v2;
        }

        public V getSource() {
            return this.source;
        }

        public V getTarget() {
            return this.target;
        }
    }
}

