/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.tinytree.CompressedWhitespace;

public class Whitespace {
    public static final int PRESERVE = 0;
    public static final int REPLACE = 1;
    public static final int COLLAPSE = 2;
    public static final int NONE = 10;
    public static final int IGNORABLE = 11;
    public static final int ALL = 12;
    public static final int UNSPECIFIED = 13;
    private static boolean[] C0WHITE = new boolean[]{false, false, false, false, false, false, false, false, false, true, true, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true};

    private Whitespace() {
    }

    public static boolean isWhitespace(int n) {
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public static CharSequence applyWhitespaceNormalization(int n, CharSequence charSequence) {
        switch (n) {
            case 0: {
                return charSequence;
            }
            case 1: {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
                for (int i = 0; i < charSequence.length(); ++i) {
                    char c = charSequence.charAt(i);
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\r': {
                            fastStringBuffer.append(' ');
                        }
                    }
                    fastStringBuffer.append(c);
                }
                return fastStringBuffer;
            }
            case 2: {
                return Whitespace.collapseWhitespace(charSequence);
            }
        }
        throw new IllegalArgumentException("Unknown whitespace facet value");
    }

    public static CharSequence removeAllWhitespace(CharSequence charSequence) {
        if (Whitespace.containsWhitespace(charSequence)) {
            FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
            for (int i = 0; i < charSequence.length(); ++i) {
                char c = charSequence.charAt(i);
                if (c <= ' ' && C0WHITE[c]) continue;
                fastStringBuffer.append(c);
            }
            return fastStringBuffer;
        }
        return charSequence;
    }

    public static CharSequence removeLeadingWhitespace(CharSequence charSequence) {
        int n = -1;
        int n2 = charSequence.length();
        for (int i = 0; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c <= ' ' && C0WHITE[c]) continue;
            n = i;
            break;
        }
        if (n == 0) {
            return charSequence;
        }
        if (n < 0 || n == n2 - 1) {
            return "";
        }
        return charSequence.subSequence(n, n2);
    }

    public static boolean containsWhitespace(CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = charSequence.charAt(n2++)) > ' ' || !C0WHITE[c]) continue;
            return true;
        }
        return false;
    }

    public static final boolean isWhite(CharSequence charSequence) {
        if (charSequence instanceof CompressedWhitespace) {
            return true;
        }
        int n = charSequence.length();
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = charSequence.charAt(n2++)) <= ' ' && C0WHITE[c]) continue;
            return false;
        }
        return true;
    }

    public static CharSequence normalizeWhitespace(CharSequence charSequence) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
        block3: for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    fastStringBuffer.append(' ');
                    continue block3;
                }
                default: {
                    fastStringBuffer.append(c);
                }
            }
        }
        return fastStringBuffer;
    }

    public static CharSequence collapseWhitespace(CharSequence charSequence) {
        int n;
        int n2 = charSequence.length();
        if (n2 == 0 || !Whitespace.containsWhitespace(charSequence)) {
            return charSequence;
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(n2);
        boolean bl = true;
        block3: for (int i = 0; i < n2; ++i) {
            n = charSequence.charAt(i);
            switch (n) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    if (bl) continue block3;
                    fastStringBuffer.append(' ');
                    bl = true;
                    continue block3;
                }
                default: {
                    fastStringBuffer.append((char)n);
                    bl = false;
                }
            }
        }
        n = fastStringBuffer.length();
        if (n > 0 && fastStringBuffer.charAt(n - '\u0001') == ' ') {
            fastStringBuffer.setLength(n - '\u0001');
        }
        return fastStringBuffer;
    }

    public static CharSequence trimWhitespace(CharSequence charSequence) {
        char c;
        if (charSequence.length() == 0) {
            return charSequence;
        }
        int n = 0;
        int n2 = charSequence.length() - 1;
        while ((c = charSequence.charAt(n)) <= ' ' && C0WHITE[c]) {
            if (n++ < n2) continue;
            return "";
        }
        while ((c = charSequence.charAt(n2)) <= ' ' && C0WHITE[c]) {
            --n2;
        }
        if (n == 0 && n2 == charSequence.length() - 1) {
            return charSequence;
        }
        return charSequence.subSequence(n, n2 + 1);
    }
}

