/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.tx;

import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.tx.StandardResource;

public class HibernateSessionResource
implements StandardResource {
    private static final Log log = Log.getLog((String)HibernateSessionResource.class.getName());
    protected Session session;
    protected Transaction transaction;

    public HibernateSessionResource(Session session) {
        this.session = session;
        if (log.isDebugEnabled()) {
            log.debug("----- beginning hibernate tx " + System.identityHashCode(session) + " --------------------------------------------------------");
        }
        try {
            this.transaction = session.beginTransaction();
        }
        catch (RuntimeException e) {
            log.error("hibernate transaction begin failed.  closing hibernate session", (Throwable)e);
            session.close();
            throw e;
        }
        if (log.isTraceEnabled()) {
            log.trace("begun hibernate tx " + System.identityHashCode(this.transaction) + " on hibernate session " + System.identityHashCode(session));
        }
    }

    public void prepare() {
        if (log.isTraceEnabled()) {
            log.trace("flushing hibernate session " + System.identityHashCode(this.session));
        }
        this.session.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        if (log.isDebugEnabled()) {
            log.debug("----- committing hibernate tx " + System.identityHashCode(this.transaction) + " -------------------------------------------------------");
        }
        try {
            this.transaction.commit();
        }
        finally {
            this.closeSession();
        }
    }

    private void closeSession() {
        if (log.isTraceEnabled()) {
            log.trace("closing hibernate session " + System.identityHashCode(this.session));
        }
        this.session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        if (log.isDebugEnabled()) {
            log.debug("----- rolling back hibernate tx " + System.identityHashCode(this.transaction) + " -----------------------------------------------------");
        }
        try {
            this.transaction.rollback();
        }
        finally {
            this.closeSession();
        }
    }
}

