/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.rm.EncoderDecoder;
import org.apache.cxf.ws.rm.RM10Constants;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.VersionTransformer;
import org.apache.cxf.ws.rm.v200502.AckRequestedType;
import org.apache.cxf.ws.rm.v200502.SequenceFaultType;
import org.apache.cxf.ws.rm.v200502.SequenceType;
import org.apache.cxf.ws.rm.v200502.TerminateSequenceType;
import org.apache.cxf.ws.rm.v200702.CloseSequenceType;
import org.apache.cxf.ws.rm.v200702.CreateSequenceResponseType;
import org.apache.cxf.ws.rm.v200702.CreateSequenceType;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.v200702.SequenceType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class EncoderDecoder10Impl
implements EncoderDecoder {
    public static final EncoderDecoder10Impl INSTANCE = new EncoderDecoder10Impl();
    private static JAXBContext jaxbContext;
    private static final Logger LOG;

    private EncoderDecoder10Impl() {
    }

    public String getWSRMNamespace() {
        return "http://schemas.xmlsoap.org/ws/2005/02/rm";
    }

    public String getWSANamespace() {
        return "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    }

    public RMConstants getConstants() {
        return RM10Constants.INSTANCE;
    }

    public Class getCreateSequenceType() {
        return org.apache.cxf.ws.rm.v200502.CreateSequenceType.class;
    }

    public Class getCreateSequenceResponseType() {
        return org.apache.cxf.ws.rm.v200502.CreateSequenceResponseType.class;
    }

    public Class getTerminateSequenceType() {
        return TerminateSequenceType.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JAXBContext getContext() throws JAXBException {
        Class<EncoderDecoder10Impl> clazz = EncoderDecoder10Impl.class;
        synchronized (EncoderDecoder10Impl.class) {
            if (jaxbContext == null) {
                Class<?> clas = RMUtils.getWSRM200502Factory().getClass();
                jaxbContext = JAXBContext.newInstance((String)PackageUtils.getPackageName(clas), (ClassLoader)clas.getClassLoader());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return jaxbContext;
        }
    }

    public Element buildHeaders(RMProperties rmps, QName qname) throws JAXBException {
        Collection<org.apache.cxf.ws.rm.v200702.AckRequestedType> reqs;
        Collection<SequenceAcknowledgement> acks;
        Document doc = DOMUtils.createDocument();
        Element header = doc.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
        Attr attr = doc.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsrm");
        attr.setValue("http://schemas.xmlsoap.org/ws/2005/02/rm");
        header.setAttributeNodeNS(attr);
        Marshaller marshaller = EncoderDecoder10Impl.getContext().createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        SequenceType seq = rmps.getSequence();
        if (null != seq) {
            LOG.log(Level.FINE, "encoding sequence into RM header");
            org.apache.cxf.ws.rm.v200502.SequenceType toseq = VersionTransformer.convert200502(seq);
            if (rmps.isLastMessage()) {
                toseq.setLastMessage(new SequenceType.LastMessage());
            }
            JAXBElement<org.apache.cxf.ws.rm.v200502.SequenceType> element = RMUtils.getWSRM200502Factory().createSequence(toseq);
            marshaller.marshal(element, (Node)header);
        }
        if (null != (acks = rmps.getAcks())) {
            LOG.log(Level.FINE, "encoding sequence acknowledgement(s) into RM header");
            for (SequenceAcknowledgement ack : acks) {
                marshaller.marshal((Object)VersionTransformer.convert200502(ack), (Node)header);
            }
        }
        if (null != (reqs = rmps.getAcksRequested())) {
            LOG.log(Level.FINE, "encoding acknowledgement request(s) into RM header");
            for (org.apache.cxf.ws.rm.v200702.AckRequestedType req : reqs) {
                marshaller.marshal(RMUtils.getWSRM200502Factory().createAckRequested(VersionTransformer.convert200502(req)), (Node)header);
            }
        }
        return header;
    }

    public Element buildHeaderFault(SequenceFault sf, QName qname) throws JAXBException {
        Document doc = DOMUtils.createDocument();
        Element header = doc.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
        Attr attr = doc.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsrm");
        attr.setValue("http://schemas.xmlsoap.org/ws/2005/02/rm");
        header.setAttributeNodeNS(attr);
        Marshaller marshaller = EncoderDecoder10Impl.getContext().createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        QName fqname = RM10Constants.SEQUENCE_FAULT_QNAME;
        SequenceFaultType flt = new SequenceFaultType();
        flt.setFaultCode(sf.getFaultCode());
        Object detail = sf.getDetail();
        if (detail instanceof Element) {
            flt.getAny().add(detail);
        } else if (detail instanceof Identifier) {
            marshaller.marshal((Object)VersionTransformer.convert200502((Identifier)detail), (Node)doc);
        } else if (detail instanceof SequenceAcknowledgement) {
            marshaller.marshal((Object)VersionTransformer.convert200502((SequenceAcknowledgement)detail), (Node)doc);
        }
        Element data = doc.getDocumentElement();
        if (data != null) {
            flt.getAny().add(data);
        }
        marshaller.marshal((Object)new JAXBElement(fqname, SequenceFaultType.class, (Object)flt), (Node)header);
        return header;
    }

    public Element encodeSequenceAcknowledgement(SequenceAcknowledgement ack) throws JAXBException {
        Document doc = DOMUtils.createDocument();
        Marshaller marshaller = EncoderDecoder10Impl.getContext().createMarshaller();
        marshaller.marshal((Object)VersionTransformer.convert200502(ack), (Node)doc);
        return (Element)doc.getFirstChild();
    }

    public Element encodeIdentifier(Identifier id) throws JAXBException {
        Document doc = DOMUtils.createDocument();
        Marshaller marshaller = EncoderDecoder10Impl.getContext().createMarshaller();
        marshaller.marshal((Object)VersionTransformer.convert200502(id), (Node)doc);
        return (Element)doc.getFirstChild();
    }

    public SequenceType decodeSequenceType(Element elem) throws JAXBException {
        Unmarshaller unmarshaller = EncoderDecoder10Impl.getContext().createUnmarshaller();
        JAXBElement jaxbElement = unmarshaller.unmarshal((Node)elem, org.apache.cxf.ws.rm.v200502.SequenceType.class);
        return VersionTransformer.convert((org.apache.cxf.ws.rm.v200502.SequenceType)jaxbElement.getValue());
    }

    public CloseSequenceType decodeSequenceTypeCloseSequence(Element elem) throws JAXBException {
        Unmarshaller unmarshaller = EncoderDecoder10Impl.getContext().createUnmarshaller();
        JAXBElement jaxbElement = unmarshaller.unmarshal((Node)elem, org.apache.cxf.ws.rm.v200502.SequenceType.class);
        org.apache.cxf.ws.rm.v200502.SequenceType seq = (org.apache.cxf.ws.rm.v200502.SequenceType)jaxbElement.getValue();
        if (seq.isSetLastMessage()) {
            CloseSequenceType close = new CloseSequenceType();
            close.setIdentifier(VersionTransformer.convert(seq.getIdentifier()));
            close.setLastMsgNumber(seq.getMessageNumber());
            return close;
        }
        return null;
    }

    public SequenceAcknowledgement decodeSequenceAcknowledgement(Element elem) throws JAXBException {
        Unmarshaller unmarshaller = EncoderDecoder10Impl.getContext().createUnmarshaller();
        org.apache.cxf.ws.rm.v200502.SequenceAcknowledgement ack = (org.apache.cxf.ws.rm.v200502.SequenceAcknowledgement)unmarshaller.unmarshal((Node)elem);
        return VersionTransformer.convert(ack);
    }

    public org.apache.cxf.ws.rm.v200702.AckRequestedType decodeAckRequestedType(Element elem) throws JAXBException {
        Unmarshaller unmarshaller = EncoderDecoder10Impl.getContext().createUnmarshaller();
        JAXBElement jaxbElement = unmarshaller.unmarshal((Node)elem, AckRequestedType.class);
        return VersionTransformer.convert((AckRequestedType)jaxbElement.getValue());
    }

    public Object convertToSend(CreateSequenceType create) {
        return VersionTransformer.convert200502(create);
    }

    public Object convertToSend(CreateSequenceResponseType create) {
        return VersionTransformer.convert200502(create);
    }

    public Object convertToSend(org.apache.cxf.ws.rm.v200702.TerminateSequenceType term) {
        return VersionTransformer.convert200502(term);
    }

    public CreateSequenceType convertReceivedCreateSequence(Object create) {
        return VersionTransformer.convert((org.apache.cxf.ws.rm.v200502.CreateSequenceType)create);
    }

    public CreateSequenceResponseType convertReceivedCreateSequenceResponse(Object response) {
        return VersionTransformer.convert((org.apache.cxf.ws.rm.v200502.CreateSequenceResponseType)response);
    }

    public org.apache.cxf.ws.rm.v200702.TerminateSequenceType convertReceivedTerminateSequence(Object term) {
        return VersionTransformer.convert((TerminateSequenceType)term);
    }

    static {
        LOG = LogUtils.getL7dLogger(EncoderDecoder10Impl.class);
    }
}

