/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.extractors;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scribe.exceptions.OAuthException;
import org.scribe.extractors.AccessTokenExtractor;
import org.scribe.extractors.RequestTokenExtractor;
import org.scribe.model.Token;
import org.scribe.utils.Preconditions;
import org.scribe.utils.URLUtils;

public class TokenExtractorImpl
implements RequestTokenExtractor,
AccessTokenExtractor {
    private static final String TOKEN_REGEX = "oauth_token=(\\S*)&oauth_token_secret=(\\S*?)(&(.*))?";

    @Override
    public Token extract(String response) {
        Preconditions.checkEmptyString(response, "Cant extract a token from null object or an empty string.");
        Matcher matcher = Pattern.compile(TOKEN_REGEX).matcher(response);
        if (matcher.matches()) {
            String token = URLUtils.percentDecode(matcher.group(1));
            String secret = URLUtils.percentDecode(matcher.group(2));
            return new Token(token, secret);
        }
        throw new OAuthException("Could not find request token or secret in response: " + response, null);
    }
}

