/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.atom.routing;

import java.util.Date;
import org.apache.abdera.model.Entry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.routing.filter.Filter;

public class EntryLastUpdatedFilter
implements Filter {
    private final transient Log logger = LogFactory.getLog(EntryLastUpdatedFilter.class);
    private Date lastUpdate;
    private boolean acceptWithoutUpdateDate = true;

    public EntryLastUpdatedFilter() {
    }

    public EntryLastUpdatedFilter(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public boolean accept(MuleMessage message) {
        Entry entry = (Entry)message.getPayload();
        Date updated = entry.getEdited();
        if (updated == null && (updated = entry.getPublished()) == null) {
            if (this.isAcceptWithoutUpdateDate()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Entry does not have a last updated or published date set, assuming the feed should be processed");
                }
                return true;
            }
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"Entry does not have a last updated or published date set, not consuming the feed because 'acceptWithoutUpdateDate' is false");
            }
            return false;
        }
        if (this.lastUpdate != null && (this.lastUpdate.after(updated) || this.lastUpdate.equals(updated))) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Feed update is not newer than the last update, not processing");
            }
            return false;
        }
        this.lastUpdate = updated;
        return true;
    }

    public boolean isAcceptWithoutUpdateDate() {
        return this.acceptWithoutUpdateDate;
    }

    public void setAcceptWithoutUpdateDate(boolean acceptWithoutUpdateDate) {
        this.acceptWithoutUpdateDate = acceptWithoutUpdateDate;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }
}

