/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.VoidMuleEvent;
import org.mule.api.DefaultMuleException;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.RouterResultsHandler;
import org.mule.api.routing.RoutingException;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transport.DispatchException;
import org.mule.config.i18n.CoreMessages;
import org.mule.execution.TransactionalExecutionTemplate;
import org.mule.management.stats.RouterStatistics;
import org.mule.processor.AbstractMessageProcessorOwner;
import org.mule.routing.CorrelationMode;
import org.mule.routing.DefaultRouterResultsHandler;
import org.mule.util.StringMessageUtils;
import org.mule.util.SystemUtils;

public abstract class AbstractOutboundRouter
extends AbstractMessageProcessorOwner
implements OutboundRouter {
    protected static List<String> magicProperties = Arrays.asList("MULE_CORRELATION_ID", "MULE_CORRELATION_ID", "MULE_CORRELATION_GROUP_SIZE", "MULE_CORRELATION_SEQUENCE", "MULE_SESSION");
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected List<MessageProcessor> routes = new CopyOnWriteArrayList<MessageProcessor>();
    protected String replyTo = null;
    protected CorrelationMode enableCorrelation = CorrelationMode.IF_NOT_SET;
    protected TransactionConfig transactionConfig;
    protected RouterResultsHandler resultsHandler = new DefaultRouterResultsHandler();
    private RouterStatistics routerStatistics;
    protected AtomicBoolean initialised = new AtomicBoolean(false);
    protected AtomicBoolean started = new AtomicBoolean(false);

    @Override
    public MuleEvent process(final MuleEvent event) throws MuleException {
        TransactionalExecutionTemplate<MuleEvent> executionTemplate = TransactionalExecutionTemplate.createTransactionalExecutionTemplate(this.muleContext, this.getTransactionConfig());
        ExecutionCallback<MuleEvent> processingCallback = new ExecutionCallback<MuleEvent>(){

            @Override
            public MuleEvent process() throws Exception {
                try {
                    return AbstractOutboundRouter.this.route(event);
                }
                catch (RoutingException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RoutingException(event, AbstractOutboundRouter.this, (Throwable)e);
                }
            }
        };
        try {
            return executionTemplate.execute(processingCallback);
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DefaultMuleException(e);
        }
    }

    protected abstract MuleEvent route(MuleEvent var1) throws MessagingException;

    protected final MuleEvent sendRequest(MuleEvent routedEvent, MuleMessage message, MessageProcessor route, boolean awaitResponse) throws MuleException {
        MuleEvent result;
        block15: {
            if (awaitResponse && this.replyTo != null) {
                this.logger.debug((Object)"event was dispatched synchronously, but there is a ReplyTo route set, so using asynchronous dispatch");
                awaitResponse = false;
            }
            this.setMessageProperties(routedEvent.getFlowConstruct(), message, route);
            if (this.logger.isDebugEnabled()) {
                if (route instanceof OutboundEndpoint) {
                    this.logger.debug((Object)("Message being sent to: " + ((OutboundEndpoint)route).getEndpointURI()));
                }
                this.logger.debug((Object)message);
            }
            if (this.logger.isTraceEnabled()) {
                try {
                    this.logger.trace((Object)("Request payload: \n" + StringMessageUtils.truncate(message.getPayloadForLogging(), 100, false)));
                    if (route instanceof OutboundEndpoint) {
                        this.logger.trace((Object)("outbound transformer is: " + ((OutboundEndpoint)route).getTransformers()));
                    }
                }
                catch (Exception e) {
                    this.logger.trace((Object)("Request payload: \n(unable to retrieve payload: " + e.getMessage()));
                    if (!(route instanceof OutboundEndpoint)) break block15;
                    this.logger.trace((Object)("outbound transformer is: " + ((OutboundEndpoint)route).getTransformers()));
                }
            }
        }
        try {
            result = this.sendRequestEvent(routedEvent, message, route, awaitResponse);
        }
        catch (MessagingException me) {
            throw me;
        }
        catch (Exception e) {
            throw new RoutingException(routedEvent, null, (Throwable)e);
        }
        if (this.getRouterStatistics() != null && this.getRouterStatistics().isEnabled()) {
            this.getRouterStatistics().incrementRoutedMessage(route);
        }
        if (result != null && !VoidMuleEvent.getInstance().equals(result)) {
            MuleMessage resultMessage = result.getMessage();
            if (this.logger.isTraceEnabled() && resultMessage != null) {
                try {
                    this.logger.trace((Object)("Response payload: \n" + StringMessageUtils.truncate(resultMessage.getPayloadForLogging(), 100, false)));
                }
                catch (Exception e) {
                    this.logger.trace((Object)("Response payload: \n(unable to retrieve payload: " + e.getMessage()));
                }
            }
        }
        return result;
    }

    protected void setMessageProperties(FlowConstruct service, MuleMessage message, MessageProcessor route) {
        if (this.replyTo != null) {
            message.setReplyTo(this.replyTo);
            message.setOutboundProperty("MULE_REPLYTO_REQUESTOR", service.getName());
            if (this.logger.isDebugEnabled() && route instanceof OutboundEndpoint) {
                this.logger.debug((Object)("Setting replyTo=" + this.replyTo + " for outbound route: " + ((OutboundEndpoint)route).getEndpointURI()));
            }
        }
        if (this.enableCorrelation != CorrelationMode.NEVER) {
            boolean correlationSet;
            boolean bl = correlationSet = message.getCorrelationId() != null;
            if (correlationSet && this.enableCorrelation == CorrelationMode.IF_NOT_SET) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("CorrelationId is already set to '" + message.getCorrelationId() + "' , not setting it again"));
                }
                return;
            }
            if (correlationSet) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("CorrelationId is already set to '" + message.getCorrelationId() + "', but router is configured to overwrite it"));
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"No CorrelationId is set on the message, will set a new Id");
            }
            String correlation = service.getMessageInfoMapping().getCorrelationId(message);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Extracted correlation Id as: " + correlation));
            }
            if (this.logger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf.append("Setting Correlation info on Outbound router");
                if (route instanceof OutboundEndpoint) {
                    buf.append(" for endpoint: ").append(((OutboundEndpoint)route).getEndpointURI());
                }
                buf.append(SystemUtils.LINE_SEPARATOR).append("Id=").append(correlation);
                this.logger.debug((Object)buf.toString());
            }
            message.setCorrelationId(correlation);
        }
    }

    @Override
    public List<MessageProcessor> getRoutes() {
        return this.routes;
    }

    @Deprecated
    public void setMessageProcessors(List<MessageProcessor> routes) throws MuleException {
        this.setRoutes(routes);
    }

    public void setRoutes(List<MessageProcessor> routes) throws MuleException {
        this.routes.clear();
        for (MessageProcessor route : routes) {
            this.addRoute(route);
        }
    }

    @Override
    public synchronized void addRoute(MessageProcessor route) throws MuleException {
        if (this.initialised.get()) {
            if (route instanceof MuleContextAware) {
                ((MuleContextAware)((Object)route)).setMuleContext(this.muleContext);
            }
            if (route instanceof FlowConstructAware) {
                ((FlowConstructAware)((Object)route)).setFlowConstruct(this.flowConstruct);
            }
            if (route instanceof Initialisable) {
                ((Initialisable)((Object)route)).initialise();
            }
        }
        if (this.started.get() && route instanceof Startable) {
            ((Startable)((Object)route)).start();
        }
        this.routes.add(route);
    }

    @Override
    public synchronized void removeRoute(MessageProcessor route) throws MuleException {
        if (this.started.get() && route instanceof Stoppable) {
            ((Stoppable)((Object)route)).stop();
        }
        if (this.initialised.get() && route instanceof Disposable) {
            ((Disposable)((Object)route)).dispose();
        }
        this.routes.remove(route);
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    @Override
    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public CorrelationMode getEnableCorrelation() {
        return this.enableCorrelation;
    }

    public void setEnableCorrelation(CorrelationMode enableCorrelation) {
        this.enableCorrelation = enableCorrelation;
    }

    public void setEnableCorrelationAsString(String enableCorrelation) {
        if (enableCorrelation != null) {
            if (enableCorrelation.equals("ALWAYS")) {
                this.enableCorrelation = CorrelationMode.ALWAYS;
            } else if (enableCorrelation.equals("NEVER")) {
                this.enableCorrelation = CorrelationMode.NEVER;
            } else if (enableCorrelation.equals("IF_NOT_SET")) {
                this.enableCorrelation = CorrelationMode.IF_NOT_SET;
            } else {
                throw new IllegalArgumentException("Value for enableCorrelation not recognised: " + enableCorrelation);
            }
        }
    }

    public TransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    @Override
    public void setTransactionConfig(TransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    @Override
    public boolean isDynamicRoutes() {
        return false;
    }

    public MessageProcessor getRoute(String name) {
        for (MessageProcessor route : this.routes) {
            OutboundEndpoint endpoint;
            if (!(route instanceof OutboundEndpoint) || !(endpoint = (OutboundEndpoint)route).getName().equals(name)) continue;
            return endpoint;
        }
        return null;
    }

    public RouterResultsHandler getResultsHandler() {
        return this.resultsHandler;
    }

    public void setResultsHandler(RouterResultsHandler resultsHandler) {
        this.resultsHandler = resultsHandler;
    }

    protected MuleEvent sendRequestEvent(MuleEvent routedEvent, MuleMessage message, MessageProcessor route, boolean awaitResponse) throws MuleException {
        int timeout;
        if (route == null) {
            throw new DispatchException(CoreMessages.objectIsNull("Outbound Endpoint"), routedEvent, null);
        }
        MuleEvent event = this.createEventToRoute(routedEvent, message, route);
        if (awaitResponse && (timeout = message.getOutboundProperty("MULE_EVENT_TIMEOUT", -1).intValue()) >= 0) {
            event.setTimeout(timeout);
        }
        return route.process(event);
    }

    protected MuleEvent createEventToRoute(MuleEvent routedEvent, MuleMessage message, MessageProcessor route) {
        return new DefaultMuleEvent(message, routedEvent, true);
    }

    protected MuleMessage cloneMessage(MuleMessage message) {
        return new DefaultMuleMessage(message.getPayload(), message, this.muleContext);
    }

    protected void propagateMagicProperties(MuleMessage in, MuleMessage out) {
        for (String name : magicProperties) {
            Object value = in.getInboundProperty(name);
            if (value == null) continue;
            out.setOutboundProperty(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialise() throws InitialisationException {
        List<MessageProcessor> list = this.routes;
        synchronized (list) {
            super.initialise();
            this.initialised.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        List<MessageProcessor> list = this.routes;
        synchronized (list) {
            super.dispose();
            this.routes = Collections.emptyList();
            this.initialised.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws MuleException {
        List<MessageProcessor> list = this.routes;
        synchronized (list) {
            super.start();
            this.started.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws MuleException {
        List<MessageProcessor> list = this.routes;
        synchronized (list) {
            super.stop();
            this.started.set(false);
        }
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public void setRouterStatistics(RouterStatistics stats) {
        this.routerStatistics = stats;
    }

    public RouterStatistics getRouterStatistics() {
        return this.routerStatistics;
    }

    @Override
    protected List<MessageProcessor> getOwnedMessageProcessors() {
        return this.routes;
    }
}

