/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.context;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.registry.RegistrationException;
import org.mule.el.context.AbstractELTestCase;

public class AppContextTestCase
extends AbstractELTestCase {
    public AppContextTestCase(AbstractELTestCase.Variant variant) {
        super(variant);
    }

    @Test
    public void name() {
        Assert.assertEquals((Object)muleContext.getConfiguration().getId(), (Object)this.evaluate("app.name"));
    }

    public void assignValueToName() {
        this.assertImmutableVariable("app.name='1'");
    }

    @Test
    public void encoding() {
        Assert.assertEquals((Object)muleContext.getConfiguration().getDefaultEncoding(), (Object)this.evaluate("app.encoding"));
    }

    public void assignValueToEncoding() {
        this.assertImmutableVariable("app.encoding='1'");
    }

    @Test
    public void workDir() {
        Assert.assertEquals((Object)muleContext.getConfiguration().getWorkingDirectory(), (Object)this.evaluate("app.workDir"));
    }

    public void assignValueToWorkDir() {
        this.assertImmutableVariable("app.workDir='1'");
    }

    @Test
    public void standalone() {
        Assert.assertFalse((String)muleContext.getClusterId(), (boolean)((Boolean)this.evaluate("app.standalone")));
    }

    public void assignValueToStandalone() {
        this.assertImmutableVariable("app.standalone='1'");
    }

    @Test
    public void registryInstanceOfMap() {
        Assert.assertTrue((boolean)(this.evaluate("app.registry") instanceof Map));
    }

    public void assignValueToRegistry() {
        this.assertImmutableVariable("app.registy='1'");
    }

    @Test
    public void registryGet() throws RegistrationException {
        Object o = new Object();
        muleContext.getRegistry().registerObject("myObject", o);
        Assert.assertEquals((Object)o, (Object)this.evaluate("app.registry.myObject"));
        Assert.assertEquals((Object)o, (Object)this.evaluate("app.registry['myObject']"));
    }

    @Test
    public void registryPut() throws RegistrationException {
        this.evaluate("app.registry.myString ='dan'");
        Assert.assertEquals((Object)"dan", (Object)muleContext.getRegistry().lookupObject("myString"));
    }

    @Test
    public void registryPutAll() throws RegistrationException {
        this.evaluate("app.registry.putAll({'1' :'one', '2' : 'two'})");
        Assert.assertEquals((Object)"one", (Object)muleContext.getRegistry().lookupObject("1"));
        Assert.assertEquals((Object)"two", (Object)muleContext.getRegistry().lookupObject("2"));
    }

    @Test
    public void registryContainsKey() throws RegistrationException {
        muleContext.getRegistry().registerObject("myString", (Object)"dan");
        Assert.assertTrue((boolean)((Boolean)this.evaluate("app.registry.containsKey('myString')")));
    }

    @Test
    public void registryEntrySet() {
        this.assertUnsupportedOperation("app.registry.entrySet()");
    }

    @Test
    public void registryIsEmpty() {
        Assert.assertFalse((boolean)((Boolean)this.evaluate("app.registry.isEmpty()")));
    }

    @Test
    public void registryClear() {
        this.assertUnsupportedOperation("app.registry.clear()");
    }

    @Test
    public void registryValues() {
        this.assertUnsupportedOperation("app.registry.values()");
    }

    @Test
    public void registrySize() {
        this.assertUnsupportedOperation("app.registry.size()");
    }

    @Test
    public void registryContainsValue() {
        this.assertUnsupportedOperation("app.registry.containsValue('foo')");
    }
}

