/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.mvel;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.el.mvel.MVELExpressionExecutor;
import org.mule.el.mvel.MVELExpressionLanguageContext;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mvel2.CompileException;
import org.mvel2.ParserContext;

@SmallTest
public class MVELExpressionExecutorTestCase
extends AbstractMuleTestCase {
    protected MVELExpressionExecutor mvel;
    protected MVELExpressionLanguageContext context;

    @Before
    public void setupMVEL() throws InitialisationException {
        this.mvel = new MVELExpressionExecutor(new ParserContext());
        this.context = (MVELExpressionLanguageContext)Mockito.mock(MVELExpressionLanguageContext.class);
        Mockito.when((Object)this.context.isResolveable(Mockito.anyString())).thenReturn((Object)false);
    }

    @Test
    public void evaluateReturnInt() {
        Assert.assertEquals((Object)4, (Object)this.mvel.execute("2*2", null));
    }

    @Test
    public void evaluateReturnString() {
        Assert.assertEquals((Object)"hi", (Object)this.mvel.execute("'hi'", null));
    }

    @Test(expected=CompileException.class)
    public void evaluateInvalidExpression() {
        Assert.assertEquals((Object)4, (Object)this.mvel.execute("2*'2", null));
    }

    @Test(expected=CompileException.class)
    public void invalidExpression() {
        this.mvel.validate("a9-#'");
    }

    @Test
    public void validExpression() {
        this.mvel.validate("var a = 2");
    }
}

