/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMessageCollection;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.processor.MessageProcessor;
import org.mule.routing.AbstractSplitter;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.Orange;

public class AbstractSplitterTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testSimpleSplitter() throws Exception {
        TestSplitter splitter = new TestSplitter();
        MultipleEventSensingMessageProcessor listener = new MultipleEventSensingMessageProcessor();
        splitter.setListener(listener);
        splitter.setMuleContext(muleContext);
        Apple apple = new Apple();
        Banana banana = new Banana();
        Orange orange = new Orange();
        FruitBowl fruitBowl = new FruitBowl();
        fruitBowl.addFruit(apple);
        fruitBowl.addFruit(banana);
        fruitBowl.addFruit(orange);
        DefaultMuleEvent inEvent = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)fruitBowl, muleContext), AbstractSplitterTestCase.getTestEvent(""));
        MuleEvent resultEvent = splitter.process((MuleEvent)inEvent);
        Assert.assertEquals((long)3L, (long)listener.events.size());
        Assert.assertTrue((boolean)(listener.events.get(0).getMessage().getPayload() instanceof Fruit));
        Assert.assertTrue((boolean)(listener.events.get(1).getMessage().getPayload() instanceof Fruit));
        Assert.assertTrue((boolean)(listener.events.get(2).getMessage().getPayload() instanceof Fruit));
        Assert.assertEquals(DefaultMessageCollection.class, resultEvent.getMessage().getClass());
        Assert.assertEquals((long)3L, (long)((MuleMessageCollection)resultEvent.getMessage()).size());
        Assert.assertTrue((boolean)(((MuleMessageCollection)resultEvent.getMessage()).getMessage(0).getPayload() instanceof Fruit));
        Assert.assertTrue((boolean)(((MuleMessageCollection)resultEvent.getMessage()).getMessage(1).getPayload() instanceof Fruit));
        Assert.assertTrue((boolean)(((MuleMessageCollection)resultEvent.getMessage()).getMessage(2).getPayload() instanceof Fruit));
    }

    private static class TestSplitter
    extends AbstractSplitter {
        private TestSplitter() {
        }

        protected List<MuleMessage> splitMessage(MuleEvent event) {
            FruitBowl bowl = (FruitBowl)event.getMessage().getPayload();
            ArrayList<MuleMessage> parts = new ArrayList<MuleMessage>();
            for (Fruit fruit : bowl.getFruit()) {
                parts.add((MuleMessage)new DefaultMuleMessage((Object)fruit, this.muleContext));
            }
            return parts;
        }
    }

    private static class MultipleEventSensingMessageProcessor
    implements MessageProcessor {
        List<MuleEvent> events = new ArrayList<MuleEvent>();

        private MultipleEventSensingMessageProcessor() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            this.events.add(event);
            return event;
        }
    }
}

