/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.rule;

import org.junit.rules.ExternalResource;

public class SystemProperty
extends ExternalResource {
    private final String name;
    private final String value;
    private boolean initialized;
    private String oldValue;

    public SystemProperty(String name, String value) {
        this.name = name;
        this.value = value;
    }

    protected void before() throws Throwable {
        if (this.initialized) {
            throw new IllegalArgumentException("System property was already initialized");
        }
        this.oldValue = System.getProperty(this.name);
        System.setProperty(this.name, this.value);
        this.initialized = true;
    }

    protected void after() {
        if (!this.initialized) {
            throw new IllegalArgumentException("System property was not initialized");
        }
        this.cleanSystemProperty();
        this.initialized = false;
    }

    protected void cleanSystemProperty() {
        if (this.oldValue == null) {
            System.clearProperty(this.name);
        } else {
            System.setProperty(this.name, this.oldValue);
        }
    }

    public String getName() {
        return this.name;
    }
}

