/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import org.junit.Assert;
import org.mule.api.transformer.Transformer;
import org.mule.transformer.AbstractTransformerTestCase;
import org.mule.transformer.simple.ObjectArrayToString;
import org.mule.transformer.simple.StringToObjectArray;

public class StringObjectArrayTransformersTestCase
extends AbstractTransformerTestCase {
    @Override
    public Transformer getTransformer() throws Exception {
        return new StringToObjectArray();
    }

    @Override
    public Transformer getRoundTripTransformer() throws Exception {
        return new ObjectArrayToString();
    }

    @Override
    public Object getTestData() {
        return "test1 test2 test3";
    }

    @Override
    public Object getResultData() {
        return new String[]{"test1", "test2", "test3"};
    }

    @Override
    public boolean compareResults(Object src, Object result) {
        if (src == null || result == null) {
            return false;
        }
        if (result instanceof Object[]) {
            Object[] out = (Object[])result;
            Assert.assertEquals((Object)out[0].toString(), (Object)"test1");
            Assert.assertEquals((Object)out[1].toString(), (Object)"test2");
            Assert.assertEquals((Object)out[2].toString(), (Object)"test3");
            return true;
        }
        return false;
    }

    @Override
    public boolean compareRoundtripResults(Object src, Object result) {
        if (src == null || result == null) {
            return false;
        }
        return src.equals(result);
    }
}

