/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.gbind;

import com.sun.tools.xjc.reader.gbind.ConnectedComponent;
import com.sun.tools.xjc.reader.gbind.ElementSet;
import com.sun.tools.xjc.reader.gbind.Expression;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Element
extends Expression
implements ElementSet {
    final Set<Element> foreEdges = new LinkedHashSet<Element>();
    final Set<Element> backEdges = new LinkedHashSet<Element>();
    Element prevPostOrder;
    private ConnectedComponent cc;

    protected Element() {
    }

    @Override
    ElementSet lastSet() {
        return this;
    }

    @Override
    boolean isNullable() {
        return false;
    }

    boolean isSource() {
        return false;
    }

    boolean isSink() {
        return false;
    }

    @Override
    void buildDAG(ElementSet incoming) {
        incoming.addNext(this);
    }

    @Override
    public void addNext(Element element) {
        this.foreEdges.add(element);
        element.backEdges.add(this);
    }

    @Override
    public boolean contains(ElementSet rhs) {
        return this == rhs || rhs == ElementSet.EMPTY_SET;
    }

    @Override
    public Iterator<Element> iterator() {
        return Collections.singleton(this).iterator();
    }

    Element assignDfsPostOrder(Element prev) {
        if (this.prevPostOrder != null) {
            return prev;
        }
        this.prevPostOrder = this;
        for (Element next : this.foreEdges) {
            prev = next.assignDfsPostOrder(prev);
        }
        this.prevPostOrder = prev;
        return this;
    }

    public void buildStronglyConnectedComponents(List<ConnectedComponent> ccs) {
        Element cur = this;
        while (cur != cur.prevPostOrder) {
            if (!cur.belongsToSCC()) {
                ConnectedComponent cc = new ConnectedComponent();
                ccs.add(cc);
                cur.formConnectedComponent(cc);
            }
            cur = cur.prevPostOrder;
        }
    }

    private boolean belongsToSCC() {
        return this.cc != null || this.isSource() || this.isSink();
    }

    private void formConnectedComponent(ConnectedComponent group2) {
        if (this.belongsToSCC()) {
            return;
        }
        this.cc = group2;
        group2.add(this);
        for (Element prev : this.backEdges) {
            prev.formConnectedComponent(group2);
        }
    }

    public boolean hasSelfLoop() {
        assert (this.foreEdges.contains(this) == this.backEdges.contains(this));
        return this.foreEdges.contains(this);
    }

    final boolean checkCutSet(ConnectedComponent cc, Set<Element> visited) {
        assert (this.belongsToSCC());
        if (this.isSink()) {
            return false;
        }
        if (!visited.add(this)) {
            return true;
        }
        if (this.cc == cc) {
            return true;
        }
        for (Element next : this.foreEdges) {
            if (next.checkCutSet(cc, visited)) continue;
            return false;
        }
        return true;
    }
}

