/*
 * $Id: SystemProperty.java 24317 2012-04-21 15:54:15Z pablo.kraan $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tck.junit4.rule;

import org.junit.rules.ExternalResource;

/**
 * Sets up a system property before a test and guaranties to tear it down
 * afterward.
 */
public class SystemProperty extends ExternalResource
{

    private final String name;
    private final String value;
    private boolean initialized;
    private String oldValue;

    public SystemProperty(String name, String value)
    {
        this.name = name;
        this.value = value;
    }

    @Override
    protected void before() throws Throwable
    {
        if (initialized)
        {
            throw new IllegalArgumentException("System property was already initialized");
        }

        oldValue = System.getProperty(name);
        System.setProperty(name, value);
        initialized = true;
    }

    @Override
    protected void after()
    {
        if (!initialized)
        {
            throw new IllegalArgumentException("System property was not initialized");
        }

        cleanSystemProperty();

        initialized = false;
    }

    protected void cleanSystemProperty()
    {
        if (oldValue == null)
        {
            System.clearProperty(name);
        }
        else
        {
            System.setProperty(name, oldValue);
        }
    }

    public String getName()
    {
        return name;
    }
}
