/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.ntlm;

import jcifs.ntlmssp.NtlmMessage;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.util.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthChallengeParser;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.InvalidCredentialsException;
import org.apache.commons.httpclient.auth.MalformedChallengeException;
import org.mule.transport.http.ntlm.NtlmMessageFactory;

public class NTLMScheme
implements AuthScheme {
    private static final String NOT_IMPLEMENTED_ERROR = "Not implemented as it is deprecated anyway in Httpclient 3.x";
    private AUTHENTICATION_STATE authenticationState = AUTHENTICATION_STATE.UNINITIATED;
    private String receivedNtlmChallenge = null;
    private final NtlmMessageFactory ntlmMessageFactory = new NtlmMessageFactory();

    public String authenticate(Credentials credentials, HttpMethod method) throws AuthenticationException {
        Type1Message response;
        if (this.authenticationState == AUTHENTICATION_STATE.UNINITIATED) {
            throw new IllegalStateException("NTLM authentication process has not been initiated");
        }
        NTCredentials ntcredentials = this.getNTCredentials(credentials);
        if (this.authenticationState == AUTHENTICATION_STATE.INITIATED || this.authenticationState == AUTHENTICATION_STATE.FAILED) {
            response = this.ntlmMessageFactory.createType1Message(null, null);
            this.authenticationState = AUTHENTICATION_STATE.TYPE1_MSG_GENERATED;
        } else {
            Type2Message type2MessageFromChallenge = this.ntlmMessageFactory.createType2Message(this.receivedNtlmChallenge);
            response = this.ntlmMessageFactory.createType3Message(ntcredentials, type2MessageFromChallenge);
            this.authenticationState = AUTHENTICATION_STATE.TYPE3_MSG_GENERATED;
        }
        return this.ntlmMessageToString((NtlmMessage)response);
    }

    private NTCredentials getNTCredentials(Credentials credentials) throws InvalidCredentialsException {
        try {
            return (NTCredentials)credentials;
        }
        catch (ClassCastException e) {
            throw new InvalidCredentialsException("Credentials cannot be used for NTLM authentication: " + credentials.getClass().getName());
        }
    }

    public String authenticate(Credentials credentials, String method, String uri) throws AuthenticationException {
        throw new RuntimeException(NOT_IMPLEMENTED_ERROR);
    }

    public String getID() {
        throw new RuntimeException(NOT_IMPLEMENTED_ERROR);
    }

    public String getParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name may not be null");
        }
        return null;
    }

    public String getRealm() {
        return null;
    }

    public String getSchemeName() {
        return "ntlm";
    }

    public boolean isComplete() {
        return this.authenticationState == AUTHENTICATION_STATE.TYPE3_MSG_GENERATED || this.authenticationState == AUTHENTICATION_STATE.FAILED;
    }

    public boolean isConnectionBased() {
        return true;
    }

    public void processChallenge(String challenge) throws MalformedChallengeException {
        String s = AuthChallengeParser.extractScheme((String)challenge);
        if (!s.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException("Invalid NTLM challenge: " + challenge);
        }
        int i = challenge.indexOf(32);
        if (i != -1) {
            s = challenge.substring(i, challenge.length());
            this.receivedNtlmChallenge = s.trim();
            this.authenticationState = AUTHENTICATION_STATE.TYPE2_MSG_RECEIVED;
        } else {
            this.receivedNtlmChallenge = null;
            this.authenticationState = this.authenticationState == AUTHENTICATION_STATE.UNINITIATED ? AUTHENTICATION_STATE.INITIATED : AUTHENTICATION_STATE.FAILED;
        }
    }

    private String ntlmMessageToString(NtlmMessage ntlmMessage) {
        return "NTLM " + Base64.encode((byte[])ntlmMessage.toByteArray());
    }

    private static enum AUTHENTICATION_STATE {
        UNINITIATED,
        INITIATED,
        TYPE1_MSG_GENERATED,
        TYPE2_MSG_RECEIVED,
        TYPE3_MSG_GENERATED,
        FAILED;

    }
}

