/*
 * Decompiled with CFR 0.152.
 */
package org.ibeans.impl.support.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final int MAX_ELEMENTS = 50;
    private static final List maskedProperties = new CopyOnWriteArrayList();
    public static final String LINE_SEPARATOR;
    protected static final Log logger;

    public static void registerMaskedPropertyName(String name) {
        if (Utils.isEmpty(name)) {
            throw new IllegalArgumentException("Cannot mask empty property name.");
        }
        maskedProperties.add(name);
    }

    public static String getString(Object answer, String defaultValue) {
        if (answer != null) {
            return answer.toString();
        }
        return defaultValue;
    }

    public static boolean getBoolean(Object answer, boolean defaultValue) {
        if (answer != null) {
            if (answer instanceof Boolean) {
                return (Boolean)answer;
            }
            if (answer instanceof String) {
                return Boolean.valueOf((String)answer);
            }
            if (answer instanceof Number) {
                Number n = (Number)answer;
                return n.intValue() > 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Value exists but cannot be converted to boolean: " + answer + ", returning default value: " + defaultValue));
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public static byte getByte(Object answer, byte defaultValue) {
        if (answer == null) {
            return defaultValue;
        }
        if (answer instanceof Number) {
            return ((Number)answer).byteValue();
        }
        if (answer instanceof String) {
            try {
                return Byte.valueOf((String)answer);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (logger.isWarnEnabled()) {
            logger.warn((Object)("Value exists but cannot be converted to byte: " + answer + ", returning default value: " + defaultValue));
        }
        return defaultValue;
    }

    public static short getShort(Object answer, short defaultValue) {
        if (answer == null) {
            return defaultValue;
        }
        if (answer instanceof Number) {
            return ((Number)answer).shortValue();
        }
        if (answer instanceof String) {
            try {
                return Short.valueOf((String)answer);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (logger.isWarnEnabled()) {
            logger.warn((Object)("Value exists but cannot be converted to short: " + answer + ", returning default value: " + defaultValue));
        }
        return defaultValue;
    }

    public static int getInt(Object answer, int defaultValue) {
        if (answer == null) {
            return defaultValue;
        }
        if (answer instanceof Number) {
            return ((Number)answer).intValue();
        }
        if (answer instanceof String) {
            try {
                return Integer.valueOf((String)answer);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (logger.isWarnEnabled()) {
            logger.warn((Object)("Value exists but cannot be converted to int: " + answer + ", returning default value: " + defaultValue));
        }
        return defaultValue;
    }

    public static long getLong(Object answer, long defaultValue) {
        if (answer == null) {
            return defaultValue;
        }
        if (answer instanceof Number) {
            return ((Number)answer).longValue();
        }
        if (answer instanceof String) {
            try {
                return Long.valueOf((String)answer);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (logger.isWarnEnabled()) {
            logger.warn((Object)("Value exists but cannot be converted to long: " + answer + ", returning default value: " + defaultValue));
        }
        return defaultValue;
    }

    public static float getFloat(Object answer, float defaultValue) {
        if (answer == null) {
            return defaultValue;
        }
        if (answer instanceof Number) {
            return ((Number)answer).floatValue();
        }
        if (answer instanceof String) {
            try {
                return Float.valueOf((String)answer).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (logger.isWarnEnabled()) {
            logger.warn((Object)("Value exists but cannot be converted to float: " + answer + ", returning default value: " + defaultValue));
        }
        return defaultValue;
    }

    public static double getDouble(Object answer, double defaultValue) {
        if (answer == null) {
            return defaultValue;
        }
        if (answer instanceof Number) {
            return ((Number)answer).doubleValue();
        }
        if (answer instanceof String) {
            try {
                return Double.valueOf((String)answer);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (logger.isWarnEnabled()) {
            logger.warn((Object)("Value exists but cannot be converted to double: " + answer + ", returning default value: " + defaultValue));
        }
        return defaultValue;
    }

    public static Properties getPropertiesFromQueryString(String query) {
        Properties props = new Properties();
        if (query == null) {
            return props;
        }
        query = new StringBuffer(query.length() + 1).append('&').append(query).toString();
        int x = 0;
        while ((x = Utils.addProperty(query, x, '&', props)) != -1) {
        }
        return props;
    }

    public static Properties getPropertiesFromString(String query, char separator) {
        Properties props = new Properties();
        if (query == null) {
            return props;
        }
        query = new StringBuffer(query.length() + 1).append(separator).append(query).toString();
        int x = 0;
        while ((x = Utils.addProperty(query, x, separator, props)) != -1) {
        }
        return props;
    }

    private static int addProperty(String query, int start, char separator, Properties properties) {
        String pair;
        int i = query.indexOf(separator, start);
        int i2 = query.indexOf(separator, i + 1);
        if (i > -1 && i2 > -1) {
            pair = query.substring(i + 1, i2);
        } else if (i > -1) {
            pair = query.substring(i + 1);
        } else {
            return -1;
        }
        int eq = pair.indexOf(61);
        if (eq <= 0) {
            String key = pair;
            String value = "";
            properties.setProperty(key, value);
        } else {
            String key = pair.substring(0, eq);
            String value = eq == pair.length() ? "" : pair.substring(eq + 1);
            properties.setProperty(key, value);
        }
        return i2;
    }

    public static Map<String, Object> convertKeyValuePairsToMap(String[] properties) {
        if (properties.length > 0) {
            HashMap<String, Object> props = new HashMap<String, Object>(properties.length);
            for (int i = 0; i < properties.length; ++i) {
                String property = properties[i];
                if (property.length() == 0) continue;
                int x = property.indexOf("=");
                if (x < 1) {
                    throw new IllegalArgumentException("Property string is malformed: " + property);
                }
                String value = property.substring(x + 1);
                property = property.substring(0, x);
                props.put(property, value);
            }
            return props;
        }
        return null;
    }

    public static String[] splitAndTrim(String string, String delim) {
        if (string == null) {
            return null;
        }
        if (Utils.isEmpty(string)) {
            return new String[0];
        }
        String[] rawTokens = string.split(delim);
        ArrayList<String> tokens = new ArrayList<String>();
        if (rawTokens != null) {
            for (int i = 0; i < rawTokens.length; ++i) {
                String token = rawTokens[i];
                if (token == null || token.length() <= 0) continue;
                tokens.add(token.trim());
            }
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String toString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Class) {
            return ((Class)o).getName();
        }
        if (o instanceof Map) {
            return Utils.toString((Map)o, false);
        }
        if (o.getClass().isArray()) {
            return o.toString();
        }
        if (o instanceof Collection) {
            return Utils.toString((Collection)o, 50);
        }
        return o.toString();
    }

    public static String toString(Map props, boolean newline) {
        int i;
        if (props == null || props.isEmpty()) {
            return "{}";
        }
        StringBuffer buf = new StringBuffer(props.size() * 32);
        buf.append('{');
        if (newline) {
            buf.append(LINE_SEPARATOR);
        }
        Object[] entries = props.entrySet().toArray();
        for (i = 0; i < entries.length - 1; ++i) {
            Map.Entry property = (Map.Entry)entries[i];
            buf.append(property.getKey());
            buf.append('=');
            buf.append(Utils.maskedPropertyValue(property));
            if (newline) {
                buf.append(LINE_SEPARATOR);
                continue;
            }
            buf.append(',').append(' ');
        }
        Map.Entry lastProperty = (Map.Entry)entries[i];
        buf.append(lastProperty.getKey().toString());
        buf.append('=');
        buf.append(Utils.maskedPropertyValue(lastProperty));
        if (newline) {
            buf.append(LINE_SEPARATOR);
        }
        buf.append('}');
        return buf.toString();
    }

    public static String maskedPropertyValue(Map.Entry property) {
        if (property == null) {
            return null;
        }
        Object key = property.getKey();
        Object value = property.getValue();
        if (key == null || value == null) {
            return null;
        }
        if (maskedProperties.contains(key)) {
            return "*****";
        }
        return value.toString();
    }

    public static String toString(Collection c, int maxElements) {
        return Utils.toString(c, maxElements, false);
    }

    public static String toString(Collection c, int maxElements, boolean newline) {
        if (c == null || c.isEmpty()) {
            return "[]";
        }
        int origNumElements = c.size();
        int numElements = Math.min(origNumElements, maxElements);
        boolean tooManyElements = origNumElements > maxElements;
        StringBuffer buf = new StringBuffer(numElements * 32);
        buf.append('[');
        if (newline) {
            buf.append(LINE_SEPARATOR);
        }
        Iterator items = c.iterator();
        for (int i = 0; i < numElements - 1; ++i) {
            Object item = items.next();
            if (item instanceof Class) {
                buf.append(((Class)item).getName());
            } else {
                buf.append(item);
            }
            if (newline) {
                buf.append(LINE_SEPARATOR);
                continue;
            }
            buf.append(',').append(' ');
        }
        Object lastItem = items.next();
        if (lastItem instanceof Class) {
            buf.append(((Class)lastItem).getName());
        } else {
            buf.append(lastItem);
        }
        if (newline) {
            buf.append(LINE_SEPARATOR);
        }
        if (tooManyElements) {
            buf.append(" [..]");
        }
        buf.append(']');
        return buf.toString();
    }

    static {
        Utils.registerMaskedPropertyName("password");
        LINE_SEPARATOR = System.getProperty("line.separator");
        logger = LogFactory.getLog(Utils.class);
    }
}

