/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.transformers;

import de.odysseus.staxon.json.JsonXMLInputFactory;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.transform.stax.StAXSource;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.module.json.transformers.AbstractToFromXmlTransformer;
import org.mule.module.json.transformers.TransformerInputs;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.IOUtils;

public class JsonToXml
extends AbstractToFromXmlTransformer {
    public JsonToXml() {
        this.registerSourceType(DataTypeFactory.STRING);
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.registerSourceType(DataTypeFactory.create(Reader.class));
        this.registerSourceType(DataTypeFactory.create(URL.class));
        this.registerSourceType(DataTypeFactory.create(File.class));
        this.setReturnDataType(DataTypeFactory.XML_STRING);
    }

    protected Object doTransform(Object src, String enc) throws TransformerException {
        JsonXMLInputFactory inputFactory = new JsonXMLInputFactory();
        inputFactory.setProperty("JsonXMLInputFactory.multiplePI", false);
        TransformerInputs inputs = new TransformerInputs((Transformer)this, src);
        try {
            StAXSource source = inputs.getInputStream() != null ? new StAXSource(inputFactory.createXMLStreamReader(inputs.getInputStream(), enc == null ? "UTF-8" : enc)) : new StAXSource(inputFactory.createXMLStreamReader(inputs.getReader()));
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            String string = this.convert(source, outputFactory);
            return string;
        }
        catch (Exception ex) {
            throw new TransformerException((Transformer)this, (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputs.getInputStream());
            IOUtils.closeQuietly((Reader)inputs.getReader());
        }
    }
}

