/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.security.provider;

import java.util.Collections;
import java.util.List;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.security.SecurityPolicy;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.util.LazyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticSecurityPolicyResolver
implements SecurityPolicyResolver {
    private List<SecurityPolicy> securityPolicies = new LazyList();

    public StaticSecurityPolicyResolver(SecurityPolicy policy) {
        if (policy != null) {
            this.securityPolicies.add(policy);
        }
    }

    public StaticSecurityPolicyResolver(List<SecurityPolicy> policies) {
        if (policies != null) {
            this.securityPolicies.addAll(policies);
        }
    }

    public Iterable<SecurityPolicy> resolve(MessageContext criteria) throws SecurityException {
        return Collections.unmodifiableList(this.securityPolicies);
    }

    public SecurityPolicy resolveSingle(MessageContext criteria) throws SecurityException {
        if (!this.securityPolicies.isEmpty()) {
            return this.securityPolicies.get(0);
        }
        return null;
    }
}

