/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ibeans.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ibeans.annotation.Call;
import org.ibeans.annotation.Template;
import org.ibeans.annotation.param.Body;
import org.ibeans.annotation.param.BodyParam;
import org.ibeans.annotation.param.HeaderParam;
import org.ibeans.api.IBeanInvoker;
import org.ibeans.api.IBeansException;
import org.ibeans.impl.IntegrationBeanInvocationHandler;
import org.ibeans.impl.InvokeAnnotationHandler;
import org.ibeans.impl.TemplateAnnotationHandler;
import org.ibeans.spi.IBeansPlugin;
import org.mule.DefaultMuleEvent;
import org.mule.api.EndpointAnnotationParser;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.component.InterfaceBinding;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.ibeans.config.CallInterfaceBinding;
import org.mule.module.ibeans.config.IBeanFlowConstruct;
import org.mule.module.ibeans.spi.MuleCallAnnotationHandler;
import org.mule.module.ibeans.spi.MuleIBeansPlugin;
import org.mule.module.ibeans.spi.support.DynamicRequestInterfaceBinding;
import org.mule.util.annotation.AnnotationMetaData;
import org.mule.util.annotation.AnnotationUtils;

public class IBeanBinding
implements InterfaceBinding {
    private static final Log logger = LogFactory.getLog(IBeanBinding.class);
    private Class interfaceClass;
    protected OutboundEndpoint endpoint;
    protected IBeanFlowConstruct flow;
    protected MuleIBeansPlugin plugin;
    protected MuleContext muleContext;

    public IBeanBinding(IBeanFlowConstruct flow, MuleContext muleContext, MuleIBeansPlugin plugin) {
        this.flow = flow;
        this.muleContext = muleContext;
        this.plugin = plugin;
    }

    public String getMethod() {
        throw new UnsupportedOperationException();
    }

    public void setMethod(String method) {
        throw new UnsupportedOperationException();
    }

    public MuleEvent process(MuleEvent event) throws MessagingException {
        try {
            return this.endpoint.process((MuleEvent)new DefaultMuleEvent(event.getMessage(), this.endpoint.getExchangePattern(), (FlowConstruct)this.flow, event.getSession()));
        }
        catch (MessagingException e) {
            throw e;
        }
        catch (MuleException e) {
            throw new MessagingException(e.getI18nMessage(), event, (Throwable)e);
        }
    }

    public void setInterface(Class interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    public Class getInterface() {
        return this.interfaceClass;
    }

    public Object createProxy(Object target) {
        HashMap<String, String> evals = new HashMap<String, String>();
        try {
            IBeanInvoker<MuleCallAnnotationHandler, TemplateAnnotationHandler, InvokeAnnotationHandler> invoker = this.plugin.getIBeanInvoker();
            ((MuleCallAnnotationHandler)invoker.getCallHandler()).setFlow(this.flow);
            List annos = AnnotationUtils.getAllMethodAnnotations((Class)this.getInterface());
            for (AnnotationMetaData metaData : annos) {
                if (metaData.getAnnotation() instanceof Call) {
                    Collection c = this.muleContext.getRegistry().lookupObjects(EndpointAnnotationParser.class);
                    String uri = ((Call)metaData.getAnnotation()).uri();
                    int i = uri.indexOf(":/");
                    String scheme = i == -1 ? "dynamic" : uri.substring(0, i);
                    boolean http = scheme.contains("http");
                    HashMap<String, String> metaInfo = new HashMap<String, String>();
                    metaInfo.put("connectorName", metaData.getClazz().getSimpleName() + "." + scheme);
                    for (EndpointAnnotationParser parser : c) {
                        Object binding;
                        OutboundEndpoint endpoint;
                        if (!parser.supports(metaData.getAnnotation(), metaData.getClazz(), metaData.getMember())) continue;
                        Method method = (Method)metaData.getMember();
                        boolean callChannel = false;
                        for (int x = 0; x < method.getParameterAnnotations().length; ++x) {
                            Annotation ann = method.getParameterAnnotations()[x][0];
                            if (!ann.annotationType().equals(Body.class) && !ann.annotationType().equals(BodyParam.class) && !ann.annotationType().equals(HeaderParam.class)) continue;
                            callChannel = true;
                            break;
                        }
                        if (callChannel || http) {
                            endpoint = parser.parseOutboundEndpoint(metaData.getAnnotation(), metaInfo);
                            binding = new CallInterfaceBinding((FlowConstruct)this.flow);
                            binding.setEndpoint((ImmutableEndpoint)endpoint);
                        } else {
                            endpoint = parser.parseInboundEndpoint(metaData.getAnnotation(), Collections.EMPTY_MAP);
                            binding = new DynamicRequestInterfaceBinding();
                            binding.setEndpoint((ImmutableEndpoint)endpoint);
                        }
                        binding.setInterface(this.getInterface());
                        binding.setMethod(metaData.getMember().toString());
                        ((MuleCallAnnotationHandler)invoker.getCallHandler()).addRouterForInterface((InterfaceBinding)binding);
                    }
                    continue;
                }
                if (!(metaData.getAnnotation() instanceof Template)) continue;
                evals.put(metaData.getMember().toString(), ((Template)metaData.getAnnotation()).value());
            }
            if (evals.size() > 0) {
                invoker.getTemplateHandler().setEvals(evals);
            }
            Object proxy = Proxy.newProxyInstance(this.getInterface().getClassLoader(), new Class[]{this.getInterface()}, this.createInvocationHandler());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Have proxy?: " + (null != proxy)));
            }
            return proxy;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(CoreMessages.failedToCreateProxyFor((Object)target), (Throwable)e);
        }
    }

    public void setEndpoint(ImmutableEndpoint e) {
        this.endpoint = (OutboundEndpoint)e;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("IBeanBinding");
        sb.append(", interface=").append(this.interfaceClass);
        sb.append('}');
        return sb.toString();
    }

    public ImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    protected InvocationHandler createInvocationHandler() throws IBeansException {
        return new IntegrationBeanInvocationHandler(this.interfaceClass, (IBeansPlugin)this.plugin);
    }
}

