/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractFileWatcher
implements Runnable {
    protected Log logger = LogFactory.getLog(this.getClass());
    private long timeStamp;
    private Collection<File> files;

    public AbstractFileWatcher(File file) {
        this(Arrays.asList(file));
    }

    public AbstractFileWatcher(Collection<File> files) {
        this.files = files;
        this.timeStamp = System.currentTimeMillis();
    }

    @Override
    public final void run() {
        long lastTimeStamp = this.timeStamp;
        File latestFile = null;
        for (File file : this.files) {
            long timestamp = file.lastModified();
            if (timestamp <= lastTimeStamp) continue;
            lastTimeStamp = this.timeStamp;
            latestFile = file;
        }
        if (latestFile != null) {
            this.timeStamp = lastTimeStamp;
            try {
                this.onChange(latestFile);
            }
            catch (Throwable t) {
                this.logger.error((Object)String.format("Monitor for %s threw an exception", latestFile), t);
            }
        }
    }

    protected abstract void onChange(File var1);
}

